/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.stresstest.workload;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.stresstest.ODatabaseIdentifier;
import com.orientechnologies.orient.stresstest.OStressTesterSettings;
import com.orientechnologies.orient.stresstest.workload.OWorkload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class OBaseWorkload
implements OWorkload {
    protected OStorageRemote.CONNECTION_STRATEGY connectionStrategy = OStorageRemote.CONNECTION_STRATEGY.STICKY;
    protected static final long MAX_ERRORS = 100L;
    protected List<String> errors = new ArrayList<String>();

    protected List<OBaseWorkLoadContext> executeOperation(final ODatabaseIdentifier dbIdentifier, final OWorkLoadResult result, OStressTesterSettings settings, final OCallable<Void, OBaseWorkLoadContext> callback) {
        int t;
        if (result.total == 0) {
            return null;
        }
        final int concurrencyLevel = settings.concurrencyLevel;
        final int operationsPerTransaction = settings.operationsPerTransaction;
        final int totalPerThread = result.total / concurrencyLevel;
        final int totalPerLastThread = totalPerThread + result.total % concurrencyLevel;
        Object[] operationTiming = new Long[result.total];
        ArrayList<OBaseWorkLoadContext> contexts = new ArrayList<OBaseWorkLoadContext>(concurrencyLevel);
        Thread[] thread = new Thread[concurrencyLevel];
        for (int t2 = 0; t2 < concurrencyLevel; ++t2) {
            final int currentThread = t2;
            final OBaseWorkLoadContext context = this.getContext();
            contexts.add(context);
            thread[t2] = new Thread(new Runnable((Long[])operationTiming, settings){
                final /* synthetic */ Long[] val$operationTiming;
                final /* synthetic */ OStressTesterSettings val$settings;
                {
                    this.val$operationTiming = longArray;
                    this.val$settings = oStressTesterSettings;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    context.threadId = currentThread;
                    context.totalPerThread = context.threadId < concurrencyLevel - 1 ? totalPerThread : totalPerLastThread;
                    context.init(dbIdentifier, operationsPerTransaction);
                    OBaseWorkload.this.init(context);
                    try {
                        final int startIdx = totalPerThread * context.threadId;
                        final AtomicInteger operationsExecutedInTx = new AtomicInteger();
                        final AtomicInteger i = new AtomicInteger();
                        while (i.get() < context.totalPerThread) {
                            ODatabaseDocumentTx.executeWithRetries(new OCallable<Object, Integer>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public Object call(Integer retry) {
                                    block15: {
                                        if (retry > 0) {
                                            i.addAndGet(operationsExecutedInTx.get() * -1);
                                            if (i.get() < 0) {
                                                i.set(0);
                                            }
                                            operationsExecutedInTx.set(0);
                                        }
                                        context.currentIdx = startIdx + i.get();
                                        long startOp = System.nanoTime();
                                        try {
                                            Object RET;
                                            try {
                                                RET = callback.call(context);
                                                operationsExecutedInTx.incrementAndGet();
                                            }
                                            catch (Throwable throwable) {
                                                try {
                                                    operationsExecutedInTx.incrementAndGet();
                                                    if (operationsPerTransaction > 0 && (i.get() + 1) % operationsPerTransaction == 0 || i.get() == context.totalPerThread - 1) {
                                                        OBaseWorkload.this.commitTransaction(context);
                                                        operationsExecutedInTx.set(0);
                                                        OBaseWorkload.this.beginTransaction(context);
                                                    }
                                                    throw throwable;
                                                }
                                                catch (ONeedRetryException e) {
                                                    result.conflicts.incrementAndGet();
                                                    OBaseWorkload.this.manageNeedRetryException(context, e);
                                                    if (operationsPerTransaction > 0) {
                                                        OBaseWorkload.this.beginTransaction(context);
                                                    }
                                                    throw e;
                                                }
                                                catch (Exception e) {
                                                    OBaseWorkload.this.errors.add(e.toString());
                                                    if ((long)OBaseWorkload.this.errors.size() > 100L) {
                                                        OLogManager.instance().error(this, "Error during execution of database of operation", e, new Object[0]);
                                                        Object var5_7 = null;
                                                        return var5_7;
                                                    }
                                                    break block15;
                                                }
                                            }
                                            if (operationsPerTransaction > 0 && (i.get() + 1) % operationsPerTransaction == 0 || i.get() == context.totalPerThread - 1) {
                                                OBaseWorkload.this.commitTransaction(context);
                                                operationsExecutedInTx.set(0);
                                                OBaseWorkload.this.beginTransaction(context);
                                            }
                                            return RET;
                                        }
                                        finally {
                                            val$operationTiming[context.currentIdx] = System.nanoTime() - startOp;
                                        }
                                    }
                                    return null;
                                }
                            }, 10);
                            if (this.val$settings.delay > 0) {
                                try {
                                    Thread.sleep(this.val$settings.delay);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            i.incrementAndGet();
                        }
                        if (operationsPerTransaction > 0) {
                            OBaseWorkload.this.commitTransaction(context);
                        }
                    }
                    finally {
                        context.close();
                    }
                }
            });
        }
        long startTime = System.currentTimeMillis();
        for (t = 0; t < concurrencyLevel; ++t) {
            thread[t].setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            thread[t].start();
        }
        for (t = 0; t < concurrencyLevel; ++t) {
            try {
                thread[t].join();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        result.totalTime = System.currentTimeMillis() - startTime;
        Arrays.sort(operationTiming);
        result.throughputAvgNs = (int)(result.totalTime * 1000000L / (long)operationTiming.length);
        result.totalTimeOperationsNs = 0L;
        Object[] objectArray = operationTiming;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            long l = (Long)objectArray[i];
            result.totalTimeOperationsNs += l;
        }
        result.latencyMinNs = (Long)operationTiming[0];
        result.latencyMaxNs = (Long)operationTiming[operationTiming.length - 1];
        result.latencyAvgNs = (int)(result.totalTimeOperationsNs / (long)operationTiming.length);
        result.latencyPercentileAvg = this.getPercentile((Long[])operationTiming, result.latencyAvgNs);
        result.latencyPercentile99Ns = (Long)operationTiming[(int)((float)operationTiming.length * 99.0f / 100.0f)];
        result.latencyPercentile99_9Ns = (Long)operationTiming[(int)((float)operationTiming.length * 99.9f / 100.0f)];
        return contexts;
    }

    protected abstract void beginTransaction(OBaseWorkLoadContext var1);

    protected abstract void commitTransaction(OBaseWorkLoadContext var1);

    protected abstract OBaseWorkLoadContext getContext();

    protected void init(OBaseWorkLoadContext context) {
    }

    protected void manageNeedRetryException(OBaseWorkLoadContext context, ONeedRetryException e) {
    }

    protected String getErrors() {
        StringBuilder buffer = new StringBuilder();
        if (!this.errors.isEmpty()) {
            buffer.append("\nERRORS:");
            for (int i = 0; i < this.errors.size(); ++i) {
                buffer.append("\n");
                buffer.append(i);
                buffer.append(": ");
                buffer.append(this.errors.get(i));
            }
        }
        return buffer.toString();
    }

    protected int getPercentile(Long[] sortedResults, long time) {
        Long valueNs;
        int j;
        for (j = 0; j < sortedResults.length && (valueNs = sortedResults[j]) <= time; ++j) {
        }
        return (int)(100.0f * ((float)j / (float)sortedResults.length));
    }

    public class OWorkLoadResult {
        public AtomicInteger current = new AtomicInteger();
        public int total = 1;
        public long totalTime;
        public long totalTimeOperationsNs;
        public long throughputAvgNs;
        public long latencyAvgNs;
        public long latencyMinNs;
        public long latencyMaxNs;
        public int latencyPercentileAvg;
        public long latencyPercentile99Ns;
        public long latencyPercentile99_9Ns;
        public AtomicInteger conflicts = new AtomicInteger();

        public String toOutput(int leftSpaces) {
            StringBuilder indent = new StringBuilder();
            for (int i = 0; i < leftSpaces; ++i) {
                indent.append(' ');
            }
            return String.format("\n%s- Throughput: %.3f/sec (Avg %.3fms/op)\n%s- Latency Avg: %.3fms/op (%dth percentile) - Min: %.3fms - 99th Perc: %.3fms - 99.9th Perc: %.3fms - Max: %.3fms - Conflicts: %d", indent, Float.valueOf((float)(this.total * 1000) / (float)this.totalTime), Float.valueOf((float)this.throughputAvgNs / 1000000.0f), indent, Float.valueOf((float)this.latencyAvgNs / 1000000.0f), this.latencyPercentileAvg, Float.valueOf((float)this.latencyMinNs / 1000000.0f), Float.valueOf((float)this.latencyPercentile99Ns / 1000000.0f), Float.valueOf((float)this.latencyPercentile99_9Ns / 1000000.0f), Float.valueOf((float)this.latencyMaxNs / 1000000.0f), this.conflicts.get());
        }

        public ODocument toJSON() {
            ODocument json = new ODocument();
            json.field("total", this.total);
            json.field("time", Float.valueOf((float)this.totalTime / 1000.0f));
            json.field("timeOperations", Float.valueOf((float)this.totalTimeOperationsNs / 1000.0f));
            json.field("throughput", Float.valueOf(this.totalTime > 0L ? (float)(this.total * 1000) / (float)this.totalTime : 0.0f));
            json.field("throughputAvg", Float.valueOf((float)this.throughputAvgNs / 1000000.0f));
            json.field("latencyAvg", Float.valueOf((float)this.latencyAvgNs / 1000000.0f));
            json.field("latencyMin", Float.valueOf((float)this.latencyMinNs / 1000000.0f));
            json.field("latencyPercAvg", this.latencyPercentileAvg);
            json.field("latencyPerc99", Float.valueOf((float)this.latencyPercentile99Ns / 1000000.0f));
            json.field("latencyPerc99_9", Float.valueOf((float)this.latencyPercentile99_9Ns / 1000000.0f));
            json.field("latencyMax", Float.valueOf((float)this.latencyMaxNs / 1000000.0f));
            json.field("conflicts", this.conflicts.get());
            return json;
        }
    }

    public abstract class OBaseWorkLoadContext {
        public int threadId;
        public int currentIdx;
        public int totalPerThread;

        public abstract void init(ODatabaseIdentifier var1, int var2);

        public abstract void close();
    }
}

