/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.manifests;

import com.jcabi.log.Logger;
import com.jcabi.manifests.ClasspathMfs;
import com.jcabi.manifests.FilesMfs;
import com.jcabi.manifests.MfMap;
import com.jcabi.manifests.Mfs;
import com.jcabi.manifests.ServletMfs;
import com.jcabi.manifests.StreamsMfs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;

public final class Manifests
implements MfMap {
    public static final MfMap DEFAULT = new Manifests();
    private final transient Map<String, String> attributes;

    public Manifests() {
        this(new HashMap<String, String>(0));
    }

    public Manifests(Map<String, String> attrs) {
        this.attributes = new ConcurrentHashMap<String, String>(attrs);
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.attributes.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.attributes.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.attributes.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> attrs) {
        this.attributes.putAll(attrs);
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.attributes.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.attributes.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.attributes.entrySet();
    }

    @Override
    public MfMap append(Mfs streams) throws IOException {
        long start = System.currentTimeMillis();
        Collection<InputStream> list = streams.fetch();
        int saved = 0;
        int ignored = 0;
        for (InputStream stream : list) {
            for (Map.Entry<String, String> attr : Manifests.load(stream).entrySet()) {
                if (this.attributes.containsKey(attr.getKey())) {
                    ++ignored;
                    continue;
                }
                this.attributes.put(attr.getKey(), attr.getValue());
                ++saved;
            }
        }
        Logger.info(this, "%d attributes loaded from %d stream(s) in %[ms]s, %d saved, %d ignored: %[list]s", this.attributes.size(), list.size(), System.currentTimeMillis() - start, saved, ignored, new TreeSet<String>(this.attributes.keySet()));
        return this;
    }

    public static String read(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute can't be NULL");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("attribute can't be empty");
        }
        if (!Manifests.exists(name)) {
            throw new IllegalArgumentException(Logger.format("Attribute '%s' not found in MANIFEST.MF file(s) among %d other attribute(s): %[list]s", name, DEFAULT.size(), new TreeSet(DEFAULT.keySet())));
        }
        return (String)DEFAULT.get(name);
    }

    public static boolean exists(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute name can't be NULL");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("attribute name can't be empty");
        }
        return DEFAULT.containsKey(name);
    }

    @Deprecated
    public static void append(ServletContext ctx) throws IOException {
        DEFAULT.append(new ServletMfs(ctx));
    }

    @Deprecated
    public static void append(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file can't be NULL");
        }
        DEFAULT.append(new FilesMfs(file));
    }

    @Deprecated
    public static void append(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("input stream can't be NULL");
        }
        DEFAULT.append(new StreamsMfs(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> load(InputStream stream) throws IOException {
        ConcurrentHashMap<String, String> props2 = new ConcurrentHashMap<String, String>(0);
        try {
            Manifest manifest = new Manifest(stream);
            Attributes attrs = manifest.getMainAttributes();
            for (Object key : attrs.keySet()) {
                String value = attrs.getValue((Attributes.Name)Attributes.Name.class.cast(key));
                props2.put(key.toString(), value);
            }
            Logger.debug(Manifests.class, "%d attribute(s) loaded %[list]s", props2.size(), new TreeSet(props2.keySet()));
        }
        catch (RuntimeException ex) {
            Logger.error(Manifests.class, "#load(): failed %[exception]s", ex);
        }
        finally {
            stream.close();
        }
        return props2;
    }

    static {
        try {
            DEFAULT.append(new ClasspathMfs());
        }
        catch (IOException ex) {
            Logger.error(Manifests.class, "#load(): '%s' failed %[exception]s", ex);
        }
    }
}

