/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.exception;

import com.orientechnologies.common.exception.OErrorCategory;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OBackupInProgressException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import java.lang.reflect.InvocationTargetException;

public enum OErrorCode {
    QUERY_PARSE_ERROR(OErrorCategory.SQL_PARSING, 1, "query parse error", OQueryParsingException.class),
    BACKUP_IN_PROGRESS(OErrorCategory.STORAGE, 2, "You are trying to start a backup, but it is already in progress", OBackupInProgressException.class),
    MVCC_ERROR(OErrorCategory.CONCURRENCY_RETRY, 3, "The version of the update is outdated compared to the persistent value, retry", OConcurrentModificationException.class),
    VALIDATION_ERROR(OErrorCategory.VALIDATION, 4, "Record validation failure", OException.class),
    GENERIC_ERROR(OErrorCategory.SQL_GENERIC, 5, "Generic Error", OException.class);

    private static OErrorCode[] codes;
    protected final OErrorCategory category;
    protected final int code;
    protected final String description;
    protected final Class<? extends OException> exceptionClass;

    private OErrorCode(OErrorCategory category, int code, String description, Class<? extends OException> exceptionClass) {
        this.category = category;
        this.code = code;
        this.description = description;
        this.exceptionClass = exceptionClass;
    }

    public int getCode() {
        return this.code;
    }

    public void throwException() {
        this.throwException(this.description, null);
    }

    public void throwException(String message) {
        this.throwException(message, null);
    }

    public void throwException(Throwable parent) {
        this.throwException(this.description, parent);
    }

    public void throwException(String message, Throwable parent) {
        OException exc = this.newException(message, parent);
        throw exc;
    }

    public OException newException(String message, Throwable parent) {
        String fullMessage = String.format("%1$06d_%2$06d - %3$s", this.category.code, this.code, message);
        try {
            return OException.wrapException(this.exceptionClass.getConstructor(String.class).newInstance(fullMessage), parent);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            OLogManager.instance().warn((Object)this, "Cannot instantiate exception " + this.exceptionClass, new Object[0]);
            return null;
        }
    }

    public static OErrorCode getErrorCode(int code) {
        return codes[code];
    }

    static {
        codes = new OErrorCode[6];
        OErrorCode[] oErrorCodeArray = OErrorCode.values();
        int n = oErrorCodeArray.length;
        for (int i = 0; i < n; ++i) {
            OErrorCode code;
            OErrorCode.codes[code.getCode()] = code = oErrorCodeArray[i];
        }
    }
}

