/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class OSignalHandler
implements SignalHandler {
    private Hashtable<Signal, SignalHandler> redefinedHandlers = new Hashtable(4);
    private List<OSignalListener> listeners = new ArrayList<OSignalListener>();

    public void registerListener(OSignalListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(OSignalListener listener) {
        this.listeners.remove(listener);
    }

    public void listenTo(String name, SignalHandler iListener) {
        Signal signal = new Signal(name);
        SignalHandler redefinedHandler = Signal.handle(signal, iListener);
        if (redefinedHandler != null) {
            this.redefinedHandlers.put(signal, redefinedHandler);
        }
    }

    @Override
    public void handle(Signal signal) {
        OLogManager.instance().warn((Object)this, "Received signal: %s", signal);
        String s = signal.toString().trim();
        if (Orient.instance().isSelfManagedShutdown() && (s.equals("SIGKILL") || s.equals("SIGHUP") || s.equals("SIGINT") || s.equals("SIGTERM"))) {
            Orient.instance().shutdown();
            System.exit(1);
        } else if (s.equals("SIGTRAP")) {
            System.out.println();
            OGlobalConfiguration.dumpConfiguration(System.out);
            System.out.println();
            Orient.instance().getProfiler().dump(System.out);
            System.out.println();
            System.out.println(Orient.instance().getProfiler().threadDump());
        } else {
            SignalHandler redefinedHandler = this.redefinedHandlers.get(signal);
            if (redefinedHandler != null) {
                redefinedHandler.handle(signal);
            }
        }
        for (OSignalListener l : this.listeners) {
            l.onSignal(signal);
        }
    }

    public void installDefaultSignals() {
        this.installDefaultSignals(this);
    }

    public void installDefaultSignals(SignalHandler iListener) {
        try {
            this.listenTo("INT", iListener);
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            this.listenTo("TERM", iListener);
        }
        catch (IllegalArgumentException ignore) {
            // empty catch block
        }
        try {
            this.listenTo("TRAP", iListener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void cancel() {
        for (Map.Entry<Signal, SignalHandler> entry : this.redefinedHandlers.entrySet()) {
            try {
                Signal.handle(entry.getKey(), entry.getValue());
            }
            catch (IllegalStateException e) {
                OLogManager.instance().error(this, "Error during reverting signal handlers to default ones", e, new Object[0]);
            }
        }
        this.redefinedHandlers.clear();
    }

    public static interface OSignalListener {
        public void onSignal(Signal var1);
    }
}

