/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.remote.OLiveQueryClientListener;
import com.orientechnologies.orient.client.remote.ORemoteQueryResult;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.message.ORemoteResultSet;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OHookReplacedRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentAbstract;
import com.orientechnologies.orient.core.db.document.OSharedContextRemote;
import com.orientechnologies.orient.core.db.document.OTransactionOptimisticClient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDeleter;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OClassIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaRemote;
import com.orientechnologies.orient.core.metadata.security.OImmutableUser;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OEdgeDelegate;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSaveThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OMicroTransaction;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationContext;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class ODatabaseDocumentRemote
extends ODatabaseDocumentAbstract {
    protected OStorageRemoteSession sessionMetadata;
    private OrientDBConfig config;
    private OStorageRemote storage;

    public ODatabaseDocumentRemote(OStorageRemote storage) {
        this.activateOnCurrentThread();
        try {
            this.status = ODatabase.STATUS.CLOSED;
            this.url = storage.getURL();
            this.storage = storage;
            this.componentsFactory = storage.getComponentsFactory();
            this.unmodifiableHooks = Collections.unmodifiableMap(this.hooks);
            this.localCache = new OLocalRecordCache();
            this.init();
            this.databaseOwner = this;
        }
        catch (Exception t) {
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException(new ODatabaseException("Error on opening database "), t);
        }
    }

    @Override
    public <DB extends ODatabase> DB open(String iUserName, String iUserPassword) {
        throw new UnsupportedOperationException("Use OrientDB");
    }

    @Override
    @Deprecated
    public <DB extends ODatabase> DB open(OToken iToken) {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    @Override
    public <DB extends ODatabase> DB create() {
        throw new UnsupportedOperationException("Deprecated Method");
    }

    @Override
    public <DB extends ODatabase> DB create(String incrementalBackupPath) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public <DB extends ODatabase> DB create(Map<OGlobalConfiguration, Object> iInitialSettings) {
        throw new UnsupportedOperationException("use OrientDB");
    }

    @Override
    public void drop() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <DB extends ODatabase> DB set(ODatabase.ATTRIBUTES iAttribute, Object iValue) {
        if (iAttribute == ODatabase.ATTRIBUTES.CUSTOM) {
            int indx;
            String stringValue = iValue.toString();
            int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
            if (indx < 0) {
                if (!"clear".equalsIgnoreCase(stringValue)) throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                String query = "alter database CUSTOM 'clear'";
                ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
                result.getResult().close();
                return (DB)this;
            } else {
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                this.setCustom(customName, customValue);
            }
            return (DB)this;
        } else {
            String query = "alter database " + iAttribute.name() + " ? ";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
            result.getResult().close();
            this.getStorage().reload();
        }
        return (DB)this;
    }

    @Override
    public <DB extends ODatabase> DB setCustom(String name, Object iValue) {
        if ("clear".equals(name) && iValue == null) {
            String query = "alter database CUSTOM 'clear'";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[0]);
            result.getResult().close();
        } else {
            String query = "alter database CUSTOM  " + name + " = ?";
            ORemoteQueryResult result = this.getStorage().command(this, query, new Object[]{iValue});
            result.getResult().close();
            this.getStorage().reload();
        }
        return (DB)this;
    }

    @Override
    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentRemote database = new ODatabaseDocumentRemote(this.storage);
        database.storage = this.storage.copy(this, database);
        database.storage.addUser();
        database.status = ODatabase.STATUS.OPEN;
        database.applyAttributes(this.config);
        database.initAtFirstOpen();
        database.user = this.user;
        this.activateOnCurrentThread();
        return database;
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException("use OrientDB");
    }

    public void internalOpen(String user, String password, OrientDBConfig config) {
        this.config = config;
        this.applyAttributes(config);
        this.applyListeners(config);
        try {
            this.storage.open(user, password, config.getConfigurations());
            this.status = ODatabase.STATUS.OPEN;
            this.initAtFirstOpen();
            this.user = new OImmutableUser(-1L, new OUser(user, password).addRole(new ORole("passthrough", null, OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT)));
            this.callOnOpenListeners();
        }
        catch (OException e) {
            this.close();
            ODatabaseRecordThreadLocal.instance().remove();
            throw e;
        }
        catch (Exception e) {
            this.close();
            ODatabaseRecordThreadLocal.instance().remove();
            throw OException.wrapException(new ODatabaseException("Cannot open database url=" + this.getURL()), e);
        }
    }

    private void applyAttributes(OrientDBConfig config) {
        for (Map.Entry<ODatabase.ATTRIBUTES, Object> attrs : config.getAttributes().entrySet()) {
            this.set(attrs.getKey(), attrs.getValue());
        }
    }

    private void initAtFirstOpen() {
        if (this.initialized) {
            return;
        }
        ORecordSerializerFactory serializerFactory = ORecordSerializerFactory.instance();
        this.serializer = serializerFactory.getFormat("onet_ser_v37");
        this.localCache.startup();
        this.componentsFactory = this.getStorage().getComponentsFactory();
        this.user = null;
        this.loadMetadata();
        this.initialized = true;
    }

    @Override
    protected void loadMetadata() {
        this.metadata = new OMetadataDefault(this);
        this.sharedContext = this.getStorage().getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote(ODatabaseDocumentRemote.this.getStorage());
                return shared;
            }
        });
        this.metadata.init(this.sharedContext);
        this.sharedContext.load(this);
    }

    private void applyListeners(OrientDBConfig config) {
        for (ODatabaseListener listener : config.getListeners()) {
            this.registerListener(listener);
        }
    }

    @Override
    public ODatabaseDocumentAbstract begin(OTransaction.TXTYPE iType) {
        this.checkOpenness();
        this.checkIfActive();
        if (this.currentTx.isActive()) {
            if (iType == OTransaction.TXTYPE.OPTIMISTIC && this.currentTx instanceof OTransactionOptimistic) {
                this.currentTx.begin();
                return this;
            }
            this.currentTx.rollback(true, 0);
        }
        if (!this.inHook.isEmpty()) {
            throw new IllegalStateException("Cannot begin a transaction while a hook is executing");
        }
        for (ODatabaseListener listener : this.browseListeners()) {
            try {
                listener.onBeforeTxBegin(this);
            }
            catch (Exception t) {
                OLogManager.instance().error(this, "Error before tx begin", t, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().error(this, "Error before tx begin", e, new Object[0]);
                throw e;
            }
        }
        switch (iType) {
            case NOTX: {
                this.setDefaultTransactionMode();
                break;
            }
            case OPTIMISTIC: {
                this.currentTx = new OTransactionOptimisticClient(this);
                break;
            }
            case PESSIMISTIC: {
                throw new UnsupportedOperationException("Pessimistic transaction");
            }
        }
        this.currentTx.begin();
        return this;
    }

    public OStorageRemoteSession getSessionMetadata() {
        return this.sessionMetadata;
    }

    public void setSessionMetadata(OStorageRemoteSession sessionMetadata) {
        this.sessionMetadata = sessionMetadata;
    }

    @Override
    public OStorageRemote getStorage() {
        return this.storage;
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        throw new UnsupportedOperationException("unsupported replace of storage for remote database");
    }

    private void checkAndSendTransaction() {
        if (this.currentTx.isActive() && ((OTransactionOptimistic)this.currentTx).isChanged()) {
            if (((OTransactionOptimistic)this.getTransaction()).isAlreadyCleared()) {
                this.storage.reBeginTransaction(this, (OTransactionOptimistic)this.currentTx);
            } else {
                this.storage.beginTransaction(this, (OTransactionOptimistic)this.currentTx);
            }
            ((OTransactionOptimistic)this.currentTx).resetChangesTracking();
            ((OTransactionOptimistic)this.currentTx).setSentToServer(true);
        }
    }

    private void fetchTransacion() {
        this.storage.fetchTransaction(this);
    }

    @Override
    public OResultSet query(String query, Object[] args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    @Override
    public OResultSet query(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.query(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    @Override
    public OResultSet indexQuery(String indexName, String query, Object ... args) {
        ORemoteQueryResult result;
        this.checkOpenness();
        if (this.getTransaction().isActive()) {
            OTransactionIndexChanges changes = this.getTransaction().getIndexChanges(indexName);
            Set<String> changedIndexes = ((OTransactionOptimisticClient)this.getTransaction()).getIndexChanged();
            if (changedIndexes.contains(indexName) || changes != null) {
                this.checkAndSendTransaction();
            }
        }
        if ((result = this.storage.command(this, query, args)).isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    @Override
    public OResultSet command(String query, Object ... args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    @Override
    public OResultSet command(String query, Map args) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.command(this, query, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    @Override
    public OResultSet execute(String language, String script, Object ... args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.execute(this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    @Override
    public OResultSet execute(String language, String script, Map<String, ?> args) throws OCommandExecutionException, OCommandScriptException {
        this.checkOpenness();
        this.checkAndSendTransaction();
        ORemoteQueryResult result = this.storage.execute(this, language, script, args);
        if (result.isTransactionUpdated()) {
            this.fetchTransacion();
        }
        if (result.isReloadMetadata()) {
            this.reload();
        }
        return result.getResult();
    }

    public void closeQuery(String queryId) {
        this.storage.closeQuery(this, queryId);
        this.queryClosed(queryId);
    }

    public void fetchNextPage(ORemoteResultSet rs) {
        this.checkOpenness();
        this.checkAndSendTransaction();
        this.storage.fetchNextPage(this, rs);
    }

    @Override
    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Object ... args) {
        return this.storage.liveQuery(this, query, new OLiveQueryClientListener(this.copy(), listener), args);
    }

    @Override
    public OLiveQueryMonitor live(String query, OLiveQueryResultListener listener, Map<String, ?> args) {
        return this.storage.liveQuery(this, query, new OLiveQueryClientListener(this.copy(), listener), args);
    }

    @Override
    public void recycle(ORecord record) {
        throw new UnsupportedOperationException();
    }

    protected OMicroTransaction beginMicroTransaction() {
        return null;
    }

    public static void deInit(OStorageRemote storage) {
        OSharedContext sharedContext = (OSharedContext)storage.removeResource(OSharedContext.class.getName());
        if (sharedContext != null) {
            sharedContext.close();
        }
    }

    public static void updateSchema(final OStorageRemote storage, ODocument schema) {
        OSharedContext shared = storage.getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote(storage);
                return shared;
            }
        });
        ((OSchemaRemote)shared.getSchema()).update(schema);
    }

    public static void updateIndexManager(final OStorageRemote storage, ODocument indexManager) {
        OSharedContext shared = storage.getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote(storage);
                return shared;
            }
        });
        ((OIndexManagerRemote)shared.getIndexManager()).update(indexManager);
    }

    public static void updateFunction(final OStorageRemote storage) {
        OSharedContext shared = storage.getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote(storage);
                return shared;
            }
        });
        shared.getFunctionLibrary().update();
    }

    public static void updateSequences(final OStorageRemote storage) {
        OSharedContext shared = storage.getResource(OSharedContext.class.getName(), new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextRemote shared = new OSharedContextRemote(storage);
                return shared;
            }
        });
        shared.getSequenceLibrary().update();
    }

    @Override
    public int addBlobCluster(String iClusterName, Object ... iParameters) {
        try (OResultSet resultSet = this.command("create blob cluster :1", iClusterName);){
            int id;
            assert (resultSet.hasNext());
            OResult result = resultSet.next();
            assert (result.getProperty("value") != null);
            int n = id = ((Integer)result.getProperty("value")).intValue();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RET extends ORecord> RET executeSaveRecord(ORecord record, String clusterName, int ver, ODatabase.OPERATION_MODE mode, boolean forceCreate, ORecordCallback<? extends Number> recordCreatedCallback, ORecordCallback<Integer> recordUpdatedCallback) {
        this.checkOpenness();
        this.checkIfActive();
        if (!record.isDirty()) {
            return (RET)record;
        }
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot create record because it has no identity. Probably is not a regular record or contains projections of fields rather than a full record");
        }
        record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
        try {
            OStorageOperationResult<Integer> operationResult;
            byte[] stream = null;
            this.getMetadata().makeThreadLocalSchemaSnapshot();
            if (record instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)record, this);
            }
            ORecordSerializationContext.pushContext();
            boolean isNew = forceCreate || rid.isNew();
            try {
                ORecord overwritten;
                if (isNew) {
                    ORecordInternal.onBeforeIdentityChanged(record);
                    int id = this.assignAndCheckCluster(record, clusterName);
                    clusterName = this.getClusterNameById(id);
                    overwritten = (ORecord)this.beforeCreateOperations(record, clusterName);
                } else {
                    overwritten = (ORecord)this.beforeUpdateOperations(record, clusterName);
                }
                if (overwritten != null) {
                    record = overwritten;
                }
                stream = this.getSerializer().toStream(record, false);
                ORecordSaveThreadLocal.setLast(record);
                try {
                    boolean updateContent = ORecordInternal.isContentChanged(record);
                    byte[] content = stream == null ? OCommonConst.EMPTY_BYTE_ARRAY : stream;
                    byte recordType = ORecordInternal.getRecordType(record);
                    int modeIndex = mode.ordinal();
                    Orient.instance().getRecordFactoryManager().getRecordTypeClass(recordType);
                    if (forceCreate || ORecordId.isNew(rid.getClusterPosition())) {
                        OStorageOperationResult<OPhysicalPosition> ppos = this.getStorage().createRecord(rid, content, ver, recordType, modeIndex, recordCreatedCallback);
                        operationResult = new OStorageOperationResult<Integer>(ppos.getResult().recordVersion, ppos.isMoved());
                    } else {
                        operationResult = this.getStorage().updateRecord(rid, updateContent, content, ver, recordType, modeIndex, recordUpdatedCallback);
                    }
                    int version = operationResult.getResult();
                    if (isNew) {
                        ((ORecordId)record.getIdentity()).copyFrom(rid);
                        ORecordInternal.onAfterIdentityChanged(record);
                    }
                    if (operationResult.getModifiedRecordContent() != null) {
                        stream = operationResult.getModifiedRecordContent();
                    } else if (version > record.getVersion() + 1 && this.getStorage() instanceof OStorageProxy) {
                        record.unload();
                    }
                    ORecordInternal.fill(record, rid, version, stream, false);
                    this.callbackHookSuccess(record, isNew, stream, operationResult);
                }
                catch (Exception t) {
                    this.callbackHookFailure(record, isNew, stream);
                    throw t;
                }
            }
            catch (Throwable throwable) {
                this.callbackHookFinalize(record, isNew, stream);
                ORecordSerializationContext.pullContext();
                this.getMetadata().clearThreadLocalSchemaSnapshot();
                ORecordSaveThreadLocal.removeLast();
                throw throwable;
            }
            this.callbackHookFinalize(record, isNew, stream);
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
            ORecordSaveThreadLocal.removeLast();
            if (stream != null && stream.length > 0 && !operationResult.isMoved()) {
                this.getLocalCache().updateRecord(record);
            }
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception t) {
            if (!ORecordId.isValid(record.getIdentity().getClusterPosition())) {
                throw OException.wrapException(new ODatabaseException("Error on saving record in cluster #" + record.getIdentity().getClusterId()), t);
            }
            throw OException.wrapException(new ODatabaseException("Error on saving record " + record.getIdentity()), t);
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return (RET)record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeDeleteRecord(OIdentifiable record, int iVersion, boolean iRequired, ODatabase.OPERATION_MODE iMode, boolean prohibitTombstones) {
        this.checkOpenness();
        this.checkIfActive();
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid == null) {
            throw new ODatabaseException("Cannot delete record because it has no identity. Probably was created from scratch or contains projections of fields rather than a full record");
        }
        if (!rid.isValid()) {
            return;
        }
        if ((record = record.getRecord()) == null) {
            return;
        }
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)this.getClusterNameById(rid.getClusterId()));
        ORecordSerializationContext.pushContext();
        this.getMetadata().makeThreadLocalSchemaSnapshot();
        try {
            if (record instanceof ODocument) {
                ODocumentInternal.checkClass((ODocument)record, this);
            }
            try {
                OStorageOperationResult<Boolean> operationResult;
                Object rec = record.getRecord();
                if (rec != null) {
                    this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, (OIdentifiable)rec);
                    if (rec instanceof ODocument) {
                        ORidBagDeleter.deleteAllRidBags((ODocument)rec);
                    }
                }
                try {
                    if (prohibitTombstones) {
                        boolean result = this.getStorage().cleanOutRecord(rid, iVersion, iMode.ordinal(), null);
                        if (!result && iRequired) {
                            throw new ORecordNotFoundException(rid);
                        }
                        operationResult = new OStorageOperationResult<Boolean>(result);
                    } else {
                        OStorageOperationResult<Boolean> result = this.getStorage().deleteRecord(rid, iVersion, iMode.ordinal(), null);
                        if (!result.getResult().booleanValue() && iRequired) {
                            throw new ORecordNotFoundException(rid);
                        }
                        operationResult = new OStorageOperationResult<Boolean>(result.getResult());
                    }
                    if (!operationResult.isMoved() && rec != null) {
                        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, (OIdentifiable)rec);
                    } else if (rec != null) {
                        this.callbackHooks(ORecordHook.TYPE.DELETE_REPLICATED, (OIdentifiable)rec);
                    }
                }
                catch (Exception t) {
                    this.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, (OIdentifiable)rec);
                    throw t;
                }
                finally {
                    this.callbackHooks(ORecordHook.TYPE.FINALIZE_DELETION, (OIdentifiable)rec);
                }
                this.clearDocumentTracking((ORecord)rec);
                if (!operationResult.isMoved()) {
                    this.getLocalCache().deleteRecord(rid);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception t) {
                throw OException.wrapException(new ODatabaseException("Error on deleting record in cluster #" + record.getIdentity().getClusterId()), t);
            }
        }
        finally {
            ORecordSerializationContext.pullContext();
            this.getMetadata().clearThreadLocalSchemaSnapshot();
        }
    }

    protected byte[] updateStream(ORecord record) {
        ORecordSerializationContext.pullContext();
        ODirtyManager manager = ORecordInternal.getDirtyManager(record);
        Set<ORecord> newRecords = manager.getNewRecords();
        Set<ORecord> updatedRecords = manager.getUpdateRecords();
        manager.clearForSave();
        if (newRecords != null) {
            for (ORecord newRecord : newRecords) {
                if (newRecord == record) continue;
                this.getTransaction().saveRecord(newRecord, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
            }
        }
        if (updatedRecords != null) {
            for (ORecord updatedRecord : updatedRecords) {
                if (updatedRecord == record) continue;
                this.getTransaction().saveRecord(updatedRecord, null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
            }
        }
        ORecordSerializationContext.pushContext();
        ORecordInternal.unsetDirty(record);
        record.setDirty();
        return this.serializer.toStream(record, false);
    }

    @Override
    public OIdentifiable beforeCreateOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_CREATE, id, iClusterName);
        ORecordHook.RESULT res = this.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, id);
        if (res == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        return null;
    }

    @Override
    public OIdentifiable beforeUpdateOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_UPDATE, id, iClusterName);
        ORecordHook.RESULT res = this.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, id);
        if (res == ORecordHook.RESULT.RECORD_CHANGED) {
            if (id instanceof ODocument) {
                ((ODocument)id).validate();
            }
            return id;
        }
        if (res == ORecordHook.RESULT.RECORD_REPLACED) {
            ORecord replaced = (ORecord)OHookReplacedRecordThreadLocal.INSTANCE.get();
            if (replaced instanceof ODocument) {
                ((ODocument)replaced).validate();
            }
            return replaced;
        }
        return null;
    }

    @Override
    public void beforeDeleteOperations(OIdentifiable id, String iClusterName) {
        this.checkClusterSecurity(ORole.PERMISSION_DELETE, id, iClusterName);
        this.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, id);
    }

    @Override
    public void afterUpdateOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)id)) != null && this.getTransaction().isActive()) {
            ArrayList<OClassIndexManager.IndexChange> indexChanges = new ArrayList<OClassIndexManager.IndexChange>();
            OClassIndexManager.processIndexOnUpdate(this, doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    @Override
    public void afterCreateOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)id)) != null && this.getTransaction().isActive()) {
            ArrayList<OClassIndexManager.IndexChange> indexChanges = new ArrayList<OClassIndexManager.IndexChange>();
            OClassIndexManager.processIndexOnCreate(this, doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    @Override
    public void afterDeleteOperations(OIdentifiable id) {
        ODocument doc;
        OImmutableClass clazz;
        this.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, id);
        if (id instanceof ODocument && (clazz = ODocumentInternal.getImmutableSchemaClass(this, doc = (ODocument)id)) != null && this.getTransaction().isActive()) {
            ArrayList<OClassIndexManager.IndexChange> indexChanges = new ArrayList<OClassIndexManager.IndexChange>();
            OClassIndexManager.processIndexOnDelete(this, doc, indexChanges);
            OTransactionOptimisticClient tx = (OTransactionOptimisticClient)this.getTransaction();
            for (OClassIndexManager.IndexChange indexChange : indexChanges) {
                tx.addIndexChanged(indexChange.index.getName());
            }
        }
    }

    @Override
    public boolean beforeReadOperations(OIdentifiable identifiable) {
        return this.callbackHooks(ORecordHook.TYPE.BEFORE_READ, identifiable) == ORecordHook.RESULT.SKIP;
    }

    @Override
    public void afterReadOperations(OIdentifiable identifiable) {
        this.callbackHooks(ORecordHook.TYPE.AFTER_READ, identifiable);
    }

    public ODatabaseDocumentAbstract delete(ORecord record) {
        this.checkOpenness();
        if (record == null) {
            throw new ODatabaseException("Cannot delete null document");
        }
        if (record instanceof OVertex) {
            this.reload(record, "in*:2 out*:2");
            OVertexDelegate.deleteLinks((OVertex)record);
        } else if (record instanceof OEdge) {
            this.reload(record, "in:1 out:1");
            OEdgeDelegate.deleteLinks((OEdge)record);
        }
        if (record instanceof ODocument && ((ODocument)record).getClassName() != null) {
            this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)((ODocument)record).getClassName());
        }
        try {
            this.currentTx.deleteRecord(record, ODatabase.OPERATION_MODE.SYNCHRONOUS);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            if (record instanceof ODocument) {
                throw OException.wrapException(new ODatabaseException("Error on deleting record " + record.getIdentity() + " of class '" + ((ODocument)record).getClassName() + "'"), e);
            }
            throw OException.wrapException(new ODatabaseException("Error on deleting record " + record.getIdentity()), e);
        }
        return this;
    }
}

