/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.hook;

import com.orientechnologies.orient.core.record.ORecord;

public interface ORecordHook {
    public void onUnregister();

    public RESULT onTrigger(TYPE var1, ORecord var2);

    public DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode();

    default public SCOPE[] getScopes() {
        return SCOPE.values();
    }

    public static enum SCOPE {
        CREATE,
        READ,
        UPDATE,
        DELETE;


        public static SCOPE typeToScope(TYPE type) {
            switch (type) {
                case BEFORE_CREATE: 
                case AFTER_CREATE: 
                case CREATE_FAILED: 
                case CREATE_REPLICATED: 
                case FINALIZE_CREATION: {
                    return CREATE;
                }
                case BEFORE_READ: 
                case AFTER_READ: 
                case READ_REPLICATED: 
                case READ_FAILED: {
                    return READ;
                }
                case BEFORE_UPDATE: 
                case AFTER_UPDATE: 
                case UPDATE_FAILED: 
                case UPDATE_REPLICATED: 
                case FINALIZE_UPDATE: {
                    return UPDATE;
                }
                case BEFORE_DELETE: 
                case AFTER_DELETE: 
                case DELETE_FAILED: 
                case DELETE_REPLICATED: 
                case FINALIZE_DELETION: {
                    return DELETE;
                }
            }
            throw new IllegalStateException("Unexpected hook type.");
        }
    }

    public static enum RESULT {
        RECORD_NOT_CHANGED,
        RECORD_CHANGED,
        SKIP,
        SKIP_IO,
        RECORD_REPLACED;

    }

    public static enum TYPE {
        ANY,
        BEFORE_CREATE,
        BEFORE_READ,
        BEFORE_UPDATE,
        BEFORE_DELETE,
        AFTER_CREATE,
        AFTER_READ,
        AFTER_UPDATE,
        AFTER_DELETE,
        CREATE_FAILED,
        READ_FAILED,
        UPDATE_FAILED,
        DELETE_FAILED,
        CREATE_REPLICATED,
        READ_REPLICATED,
        UPDATE_REPLICATED,
        DELETE_REPLICATED,
        FINALIZE_UPDATE,
        FINALIZE_CREATION,
        FINALIZE_DELETION;

    }

    public static enum HOOK_POSITION {
        FIRST,
        EARLY,
        REGULAR,
        LATE,
        LAST;

    }

    public static enum DISTRIBUTED_EXECUTION_MODE {
        TARGET_NODE,
        SOURCE_NODE,
        BOTH;

    }
}

