/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexException;
import java.util.ArrayList;
import java.util.List;

public class OCompositeCollate
implements OCollate {
    private static final long serialVersionUID = 8683726773893639905L;
    private final OAbstractIndexDefinition oCompositeIndexDefinition;
    private final List<OCollate> collates = new ArrayList<OCollate>();

    public OCompositeCollate(OAbstractIndexDefinition oCompositeIndexDefinition) {
        this.oCompositeIndexDefinition = oCompositeIndexDefinition;
    }

    public void addCollate(OCollate collate) {
        this.collates.add(collate);
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("getName");
    }

    @Override
    public Object transform(Object obj) {
        int i;
        List keys2;
        if (obj instanceof OCompositeKey) {
            OCompositeKey compositeKey = (OCompositeKey)obj;
            keys2 = compositeKey.getKeys();
        } else if (obj instanceof List) {
            keys2 = (List)obj;
        } else {
            throw new OIndexException("Impossible add as key of a CompositeIndex a value of type " + obj.getClass());
        }
        OCompositeKey transformedKey = new OCompositeKey();
        int size = Math.min(keys2.size(), this.collates.size());
        for (i = 0; i < size; ++i) {
            Object key = keys2.get(i);
            OCollate collate = this.collates.get(i);
            transformedKey.addKey(collate.transform(key));
        }
        for (i = size; i < keys2.size(); ++i) {
            transformedKey.addKey(keys2.get(i));
        }
        return transformedKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCompositeCollate that = (OCompositeCollate)o;
        return this.collates.equals(that.collates);
    }

    public int hashCode() {
        return this.collates.hashCode();
    }

    public List<OCollate> getCollates() {
        return this.collates;
    }

    public String toString() {
        return "OCompositeCollate{collates=" + this.collates + ", null values ignored = " + this.oCompositeIndexDefinition.isNullValuesIgnored() + '}';
    }
}

