/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeCollate;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OSimpleKeyIndexDefinition
extends OAbstractIndexDefinition {
    private static final long serialVersionUID = -1264300379465791244L;
    private OType[] keyTypes;

    public OSimpleKeyIndexDefinition(OType ... keyTypes) {
        this.keyTypes = keyTypes;
    }

    public OSimpleKeyIndexDefinition() {
    }

    public OSimpleKeyIndexDefinition(OType[] keyTypes2, List<OCollate> collatesList) {
        this.keyTypes = Arrays.copyOf(keyTypes2, keyTypes2.length);
        if (this.keyTypes.length > 1) {
            OCompositeCollate collate = new OCompositeCollate(this);
            if (collatesList != null) {
                for (OCollate oCollate : collatesList) {
                    collate.addCollate(oCollate);
                }
            } else {
                int typesSize = this.keyTypes.length;
                OCollate defCollate = OSQLEngine.getCollate("default");
                for (int i = 0; i < typesSize; ++i) {
                    collate.addCollate(defCollate);
                }
            }
            this.collate = collate;
        }
    }

    @Override
    public List<String> getFields() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getFieldsToIndex() {
        return Collections.emptyList();
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public Object createValue(List<?> params) {
        return this.createValue(params != null ? params.toArray() : null);
    }

    @Override
    public Object createValue(Object ... params) {
        if (params == null || params.length == 0) {
            return null;
        }
        if (this.keyTypes.length == 1) {
            return OType.convert(params[0], this.keyTypes[0].getDefaultJavaType());
        }
        OCompositeKey compositeKey = new OCompositeKey();
        for (int i = 0; i < params.length; ++i) {
            Comparable paramValue = (Comparable)OType.convert(params[i], this.keyTypes[i].getDefaultJavaType());
            if (paramValue == null) {
                return null;
            }
            compositeKey.addKey(paramValue);
        }
        return compositeKey;
    }

    @Override
    public int getParamCount() {
        return this.keyTypes.length;
    }

    @Override
    public OType[] getTypes() {
        return Arrays.copyOf(this.keyTypes, this.keyTypes.length);
    }

    @Override
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.serializeToStream();
            ODocument oDocument = this.document;
            return oDocument;
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    @Override
    protected void serializeToStream() {
        super.serializeToStream();
        ArrayList<String> keyTypeNames = new ArrayList<String>(this.keyTypes.length);
        for (OType keyType : this.keyTypes) {
            keyTypeNames.add(keyType.toString());
        }
        this.document.field("keyTypes", keyTypeNames, OType.EMBEDDEDLIST);
        if (this.collate instanceof OCompositeCollate) {
            ArrayList<String> collatesNames = new ArrayList<String>();
            for (OCollate curCollate : ((OCompositeCollate)this.collate).getCollates()) {
                collatesNames.add(curCollate.getName());
            }
            this.document.field("collates", collatesNames, OType.EMBEDDEDLIST);
        } else {
            this.document.field("collate", this.collate.getName());
        }
        this.document.field("nullValuesIgnored", this.isNullValuesIgnored());
    }

    @Override
    protected void fromStream() {
        this.serializeFromStream();
    }

    @Override
    protected void serializeFromStream() {
        super.serializeFromStream();
        List keyTypeNames = (List)this.document.field("keyTypes");
        this.keyTypes = new OType[keyTypeNames.size()];
        int i = 0;
        for (String keyTypeName : keyTypeNames) {
            this.keyTypes[i] = OType.valueOf(keyTypeName);
            ++i;
        }
        String collate = (String)this.document.field("collate");
        if (collate != null) {
            this.setCollate(collate);
        } else {
            List collatesNames = (List)this.document.field("collates");
            if (collatesNames != null) {
                OCompositeCollate collates = new OCompositeCollate(this);
                for (String collateName : collatesNames) {
                    collates.addCollate(OSQLEngine.getCollate(collateName));
                }
                this.collate = collates;
            }
        }
        this.setNullValuesIgnored(!Boolean.FALSE.equals(this.document.field("nullValuesIgnored")));
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        throw new OIndexException("This method is not supported in given index definition.");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSimpleKeyIndexDefinition that = (OSimpleKeyIndexDefinition)o;
        return Arrays.equals((Object[])this.keyTypes, (Object[])that.keyTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keyTypes != null ? Arrays.hashCode((Object[])this.keyTypes) : 0);
        return result;
    }

    @Override
    public String toString() {
        return "OSimpleKeyIndexDefinition{keyTypes=" + (this.keyTypes == null ? null : Arrays.asList(this.keyTypes)) + '}';
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType, String engine) {
        StringBuilder ddl = new StringBuilder("create index `");
        ddl.append(indexName).append("` ").append(indexType).append(' ');
        if (this.keyTypes != null && this.keyTypes.length > 0) {
            ddl.append(this.keyTypes[0].toString());
            for (int i = 1; i < this.keyTypes.length; ++i) {
                ddl.append(", ").append(this.keyTypes[i].toString());
            }
        }
        return ddl.toString();
    }

    @Override
    public boolean isAutomatic() {
        return false;
    }
}

