/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.result.binary;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OSerializableWrapper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.util.ODateHelper;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class OResultSerializerNetwork {
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final ORecordId NULL_RECORD_ID = new ORecordId(-2, -1L);
    private static final long MILLISEC_PER_DAY = 86400000L;

    public OResultInternal deserialize(BytesContainer bytes) {
        OType type;
        String fieldName;
        OResultInternal document = new OResultInternal();
        int size = OVarIntSerializer.readAsInteger(bytes);
        while (size-- > 0) {
            int len = OVarIntSerializer.readAsInteger(bytes);
            fieldName = this.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
            bytes.skip(len);
            type = this.readOType(bytes);
            if (type == null) {
                document.setProperty(fieldName, null);
                continue;
            }
            Object value = this.deserializeValue(bytes, type);
            document.setProperty(fieldName, value);
        }
        int metadataSize = OVarIntSerializer.readAsInteger(bytes);
        while (metadataSize-- > 0) {
            int len = OVarIntSerializer.readAsInteger(bytes);
            fieldName = this.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
            bytes.skip(len);
            type = this.readOType(bytes);
            if (type == null) {
                document.setMetadata(fieldName, null);
                continue;
            }
            Object value = this.deserializeValue(bytes, type);
            document.setMetadata(fieldName, value);
        }
        return document;
    }

    public void serialize(OResult document, BytesContainer bytes) {
        Set<String> fieldNames = document.getPropertyNames();
        OVarIntSerializer.write(bytes, fieldNames.size());
        for (String field : fieldNames) {
            this.writeString(bytes, field);
            Object value = document.getProperty(field);
            if (value != null) {
                if (value instanceof OResult) {
                    if (((OResult)value).isElement()) {
                        OElement elem = ((OResult)value).getElement().get();
                        this.writeOType(bytes, bytes.alloc(1), OType.LINK);
                        this.serializeValue(bytes, elem.getIdentity(), OType.LINK, null);
                        continue;
                    }
                    this.writeOType(bytes, bytes.alloc(1), OType.EMBEDDED);
                    this.serializeValue(bytes, value, OType.EMBEDDED, null);
                    continue;
                }
                OType type = OType.getTypeByValue(value);
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the Result binary serializer");
                }
                this.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, value, type, null);
                continue;
            }
            this.writeOType(bytes, bytes.alloc(1), null);
        }
        Set<String> metadataKeys = document.getMetadataKeys();
        OVarIntSerializer.write(bytes, metadataKeys.size());
        for (String field : metadataKeys) {
            this.writeString(bytes, field);
            Object value = document.getMetadata(field);
            if (value != null) {
                if (value instanceof OResult) {
                    this.writeOType(bytes, bytes.alloc(1), OType.EMBEDDED);
                    this.serializeValue(bytes, value, OType.EMBEDDED, null);
                    continue;
                }
                OType type = OType.getTypeByValue(value);
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the Result binary serializer");
                }
                this.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, value, type, null);
                continue;
            }
            this.writeOType(bytes, bytes.alloc(1), null);
        }
    }

    protected OType readOType(BytesContainer bytes) {
        byte val = this.readByte(bytes);
        if (val == -1) {
            return null;
        }
        return OType.getById(val);
    }

    private void writeOType(BytesContainer bytes, int pos, OType type) {
        bytes.bytes[pos] = type == null ? -1 : (byte)type.getId();
    }

    public Object deserializeValue(BytesContainer bytes, OType type) {
        Object value = null;
        switch (type) {
            case INTEGER: {
                value = OVarIntSerializer.readAsInteger(bytes);
                break;
            }
            case LONG: {
                value = OVarIntSerializer.readAsLong(bytes);
                break;
            }
            case SHORT: {
                value = OVarIntSerializer.readAsShort(bytes);
                break;
            }
            case STRING: {
                value = this.readString(bytes);
                break;
            }
            case DOUBLE: {
                value = Double.longBitsToDouble(this.readLong(bytes));
                break;
            }
            case FLOAT: {
                value = Float.valueOf(Float.intBitsToFloat(this.readInteger(bytes)));
                break;
            }
            case BYTE: {
                value = this.readByte(bytes);
                break;
            }
            case BOOLEAN: {
                value = this.readByte(bytes) == 1;
                break;
            }
            case DATETIME: {
                value = new Date(OVarIntSerializer.readAsLong(bytes));
                break;
            }
            case DATE: {
                long savedTime = OVarIntSerializer.readAsLong(bytes) * 86400000L;
                savedTime = this.convertDayToTimezone(TimeZone.getTimeZone("GMT"), ODateHelper.getDatabaseTimeZone(), savedTime);
                value = new Date(savedTime);
                break;
            }
            case EMBEDDED: {
                value = this.deserialize(bytes);
                break;
            }
            case EMBEDDEDSET: {
                value = this.readEmbeddedCollection(bytes, new LinkedHashSet<Object>());
                break;
            }
            case EMBEDDEDLIST: {
                value = this.readEmbeddedCollection(bytes, new ArrayList<Object>());
                break;
            }
            case LINKSET: {
                value = this.readLinkCollection(bytes, new LinkedHashSet<OIdentifiable>());
                break;
            }
            case LINKLIST: {
                value = this.readLinkCollection(bytes, new ArrayList<OIdentifiable>());
                break;
            }
            case BINARY: {
                value = this.readBinary(bytes);
                break;
            }
            case LINK: {
                value = this.readOptimizedLink(bytes);
                break;
            }
            case LINKMAP: {
                value = this.readLinkMap(bytes);
                break;
            }
            case EMBEDDEDMAP: {
                value = this.readEmbeddedMap(bytes);
                break;
            }
            case DECIMAL: {
                value = ODecimalSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
                bytes.skip(ODecimalSerializer.INSTANCE.getObjectSize(bytes.bytes, bytes.offset));
                break;
            }
            case LINKBAG: {
                throw new UnsupportedOperationException("LINKBAG should never appear in a projection");
            }
            case TRANSIENT: {
                break;
            }
            case CUSTOM: {
                try {
                    String className = this.readString(bytes);
                    Class<?> clazz = Class.forName(className);
                    OSerializableStream stream = (OSerializableStream)clazz.newInstance();
                    stream.fromStream(this.readBinary(bytes));
                    if (stream instanceof OSerializableWrapper) {
                        value = ((OSerializableWrapper)stream).getSerializable();
                        break;
                    }
                    value = stream;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return value;
    }

    private byte[] readBinary(BytesContainer bytes) {
        int n = OVarIntSerializer.readAsInteger(bytes);
        byte[] newValue = new byte[n];
        System.arraycopy(bytes.bytes, bytes.offset, newValue, 0, newValue.length);
        bytes.skip(n);
        return newValue;
    }

    private Map<Object, OIdentifiable> readLinkMap(BytesContainer bytes) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        HashMap<Object, OIdentifiable> result = new HashMap<Object, OIdentifiable>();
        while (size-- > 0) {
            OType keyType = this.readOType(bytes);
            Object key = this.deserializeValue(bytes, keyType);
            ORecordId value = this.readOptimizedLink(bytes);
            if (value.equals(NULL_RECORD_ID)) {
                result.put(key, null);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private Map readEmbeddedMap(BytesContainer bytes) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        LinkedHashMap<String, Object> document = new LinkedHashMap<String, Object>();
        while (size-- > 0) {
            int len = OVarIntSerializer.readAsInteger(bytes);
            String fieldName = this.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
            bytes.skip(len);
            OType type = this.readOType(bytes);
            if (type == null) {
                document.put(fieldName, null);
                continue;
            }
            Object value = this.deserializeValue(bytes, type);
            document.put(fieldName, value);
        }
        return document;
    }

    private Collection<OIdentifiable> readLinkCollection(BytesContainer bytes, Collection<OIdentifiable> found) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            ORecordId id = this.readOptimizedLink(bytes);
            if (id.equals(NULL_RECORD_ID)) {
                found.add(null);
                continue;
            }
            found.add(id);
        }
        return found;
    }

    private ORecordId readOptimizedLink(BytesContainer bytes) {
        return new ORecordId(OVarIntSerializer.readAsInteger(bytes), OVarIntSerializer.readAsLong(bytes));
    }

    private Collection<?> readEmbeddedCollection(BytesContainer bytes, Collection<Object> found) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            OType itemType = this.readOType(bytes);
            if (itemType == null) {
                found.add(null);
                continue;
            }
            found.add(this.deserializeValue(bytes, itemType));
        }
        return found;
    }

    public void serializeValue(BytesContainer bytes, Object value, OType type, OType linkedType) {
        switch (type) {
            case INTEGER: 
            case LONG: 
            case SHORT: {
                OVarIntSerializer.write(bytes, ((Number)value).longValue());
                break;
            }
            case STRING: {
                this.writeString(bytes, value.toString());
                break;
            }
            case DOUBLE: {
                long dg = Double.doubleToLongBits((Double)value);
                int pointer = bytes.alloc(8);
                OLongSerializer.INSTANCE.serializeLiteral(dg, bytes.bytes, pointer);
                break;
            }
            case FLOAT: {
                int fg = Float.floatToIntBits(((Float)value).floatValue());
                int pointer = bytes.alloc(4);
                OIntegerSerializer.INSTANCE.serializeLiteral(fg, bytes.bytes, pointer);
                break;
            }
            case BYTE: {
                int pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Byte)value;
                break;
            }
            case BOOLEAN: {
                int pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Boolean)value != false ? (byte)1 : 0;
                break;
            }
            case DATETIME: {
                if (value instanceof Long) {
                    OVarIntSerializer.write(bytes, (Long)value);
                    break;
                }
                OVarIntSerializer.write(bytes, ((Date)value).getTime());
                break;
            }
            case DATE: {
                long dateValue = value instanceof Long ? ((Long)value).longValue() : ((Date)value).getTime();
                dateValue = this.convertDayToTimezone(ODateHelper.getDatabaseTimeZone(), TimeZone.getTimeZone("GMT"), dateValue);
                OVarIntSerializer.write(bytes, dateValue / 86400000L);
                break;
            }
            case EMBEDDED: {
                if (!(value instanceof OResult)) {
                    throw new UnsupportedOperationException();
                }
                this.serialize((OResult)value, bytes);
                break;
            }
            case EMBEDDEDSET: 
            case EMBEDDEDLIST: {
                if (value.getClass().isArray()) {
                    this.writeEmbeddedCollection(bytes, Arrays.asList(OMultiValue.array(value)));
                    break;
                }
                this.writeEmbeddedCollection(bytes, (Collection)value);
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = (BigDecimal)value;
                int pointer = bytes.alloc(ODecimalSerializer.INSTANCE.getObjectSize(decimalValue, new Object[0]));
                ODecimalSerializer.INSTANCE.serialize(decimalValue, bytes.bytes, pointer, new Object[0]);
                break;
            }
            case BINARY: {
                this.writeBinary(bytes, (byte[])value);
                break;
            }
            case LINKSET: 
            case LINKLIST: {
                Collection ridCollection = (Collection)value;
                this.writeLinkCollection(bytes, ridCollection);
                break;
            }
            case LINK: {
                if (!(value instanceof OIdentifiable)) {
                    throw new OValidationException("Value '" + value + "' is not a OIdentifiable");
                }
                this.writeOptimizedLink(bytes, (OIdentifiable)value);
                break;
            }
            case LINKMAP: {
                this.writeLinkMap(bytes, (Map)value);
                break;
            }
            case EMBEDDEDMAP: {
                this.writeEmbeddedMap(bytes, (Map)value);
                break;
            }
            case LINKBAG: {
                throw new UnsupportedOperationException("LINKBAG should never appear in a projection");
            }
            case CUSTOM: {
                if (!(value instanceof OSerializableStream)) {
                    value = new OSerializableWrapper((Serializable)value);
                }
                this.writeString(bytes, value.getClass().getName());
                this.writeBinary(bytes, ((OSerializableStream)value).toStream());
                break;
            }
            case TRANSIENT: {
                break;
            }
        }
    }

    private int writeBinary(BytesContainer bytes, byte[] valueBytes) {
        int pointer = OVarIntSerializer.write(bytes, valueBytes.length);
        int start = bytes.alloc(valueBytes.length);
        System.arraycopy(valueBytes, 0, bytes.bytes, start, valueBytes.length);
        return pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLinkMap(BytesContainer bytes, Map<Object, OIdentifiable> map) {
        boolean disabledAutoConversion;
        boolean bl = disabledAutoConversion = map instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)map)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(false);
        }
        try {
            int fullPos = OVarIntSerializer.write(bytes, map.size());
            for (Map.Entry<Object, OIdentifiable> entry : map.entrySet()) {
                OType type = OType.STRING;
                this.writeOType(bytes, bytes.alloc(1), type);
                this.writeString(bytes, entry.getKey().toString());
                if (entry.getValue() == null) {
                    this.writeNullLink(bytes);
                    continue;
                }
                this.writeOptimizedLink(bytes, entry.getValue());
            }
            int n = fullPos;
            return n;
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(true);
            }
        }
    }

    private void writeEmbeddedMap(BytesContainer bytes, Map<Object, Object> map) {
        Set<Object> fieldNames = map.keySet();
        OVarIntSerializer.write(bytes, map.size());
        for (Object f : fieldNames) {
            if (!(f instanceof String)) {
                throw new OSerializationException("Invalid key type for map: " + f + " (only Strings supported)");
            }
            String field = (String)f;
            this.writeString(bytes, field);
            Object value = map.get(field);
            if (value != null) {
                if (value instanceof OResult) {
                    this.writeOType(bytes, bytes.alloc(1), OType.EMBEDDED);
                    this.serializeValue(bytes, value, OType.EMBEDDED, null);
                    continue;
                }
                OType type = OType.getTypeByValue(value);
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the Result binary serializer");
                }
                this.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, value, type, null);
                continue;
            }
            this.writeOType(bytes, bytes.alloc(1), null);
        }
    }

    private int writeNullLink(BytesContainer bytes) {
        int pos = OVarIntSerializer.write(bytes, NULL_RECORD_ID.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, NULL_RECORD_ID.getIdentity().getClusterPosition());
        return pos;
    }

    private int writeOptimizedLink(BytesContainer bytes, OIdentifiable link) {
        Object real;
        if (!link.getIdentity().isPersistent() && (real = link.getRecord()) != null) {
            link = real;
        }
        int pos = OVarIntSerializer.write(bytes, link.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, link.getIdentity().getClusterPosition());
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLinkCollection(BytesContainer bytes, Collection<OIdentifiable> value) {
        boolean disabledAutoConversion;
        int pos = OVarIntSerializer.write(bytes, value.size());
        boolean bl = disabledAutoConversion = value instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)value)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(false);
        }
        try {
            for (OIdentifiable itemValue : value) {
                if (itemValue == null) {
                    this.writeNullLink(bytes);
                    continue;
                }
                this.writeOptimizedLink(bytes, itemValue);
            }
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(true);
            }
        }
        return pos;
    }

    private void writeEmbeddedCollection(BytesContainer bytes, Collection<?> value) {
        OVarIntSerializer.write(bytes, value.size());
        for (Object itemValue : value) {
            if (itemValue == null) {
                this.writeOType(bytes, bytes.alloc(1), null);
                continue;
            }
            OType type = this.getTypeFromValueEmbedded(itemValue);
            if (type != null) {
                this.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, itemValue, type, null);
                continue;
            }
            throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
        }
    }

    private OType getTypeFromValueEmbedded(Object fieldValue) {
        OType type;
        OType oType = type = fieldValue instanceof OResult ? OType.EMBEDDED : OType.getTypeByValue(fieldValue);
        if (type == OType.LINK && fieldValue instanceof ODocument && !((ODocument)fieldValue).getIdentity().isValid()) {
            type = OType.EMBEDDED;
        }
        return type;
    }

    protected String readString(BytesContainer bytes) {
        int len = OVarIntSerializer.readAsInteger(bytes);
        String res = this.stringFromBytes(bytes.bytes, bytes.offset, len);
        bytes.skip(len);
        return res;
    }

    protected int readInteger(BytesContainer container) {
        int value = OIntegerSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 4;
        return value;
    }

    private byte readByte(BytesContainer container) {
        return container.bytes[container.offset++];
    }

    private long readLong(BytesContainer container) {
        long value = OLongSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 8;
        return value;
    }

    private int writeEmptyString(BytesContainer bytes) {
        return OVarIntSerializer.write(bytes, 0L);
    }

    private int writeString(BytesContainer bytes, String toWrite) {
        byte[] nameBytes = this.bytesFromString(toWrite);
        int pointer = OVarIntSerializer.write(bytes, nameBytes.length);
        int start = bytes.alloc(nameBytes.length);
        System.arraycopy(nameBytes, 0, bytes.bytes, start, nameBytes.length);
        return pointer;
    }

    private byte[] bytesFromString(String toWrite) {
        try {
            return toWrite.getBytes(CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string encoding"), e);
        }
    }

    protected String stringFromBytes(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string decoding"), e);
        }
    }

    private long convertDayToTimezone(TimeZone from, TimeZone to, long time) {
        Calendar fromCalendar = Calendar.getInstance(from);
        fromCalendar.setTimeInMillis(time);
        Calendar toCalendar = Calendar.getInstance(to);
        toCalendar.setTimeInMillis(0L);
        toCalendar.set(0, fromCalendar.get(0));
        toCalendar.set(1, fromCalendar.get(1));
        toCalendar.set(2, fromCalendar.get(2));
        toCalendar.set(5, fromCalendar.get(5));
        toCalendar.set(11, 0);
        toCalendar.set(12, 0);
        toCalendar.set(13, 0);
        toCalendar.set(14, 0);
        return toCalendar.getTimeInMillis();
    }

    public void toStream(OResult item, OChannelDataOutput channel) throws IOException {
        BytesContainer bytes = new BytesContainer();
        this.serialize(item, bytes);
        channel.writeBytes(bytes.fitBytes());
    }

    public OResultInternal fromStream(OChannelDataInput channel) throws IOException {
        BytesContainer bytes = new BytesContainer();
        bytes.bytes = channel.readBytes();
        return this.deserialize(bytes);
    }
}

