/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.graph;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.functions.graph.OSQLFunctionMoveFiltered;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class OSQLFunctionOut
extends OSQLFunctionMoveFiltered {
    public static final String NAME = "out";

    public OSQLFunctionOut() {
        super(NAME, 0, -1);
    }

    @Override
    protected Object move(ODatabase graph, OIdentifiable iRecord, String[] iLabels) {
        return this.v2v(graph, iRecord, ODirection.OUT, iLabels);
    }

    @Override
    protected Object move(ODatabase graph, OIdentifiable iRecord, String[] iLabels, Iterable<OIdentifiable> iPossibleResults) {
        Object result;
        int size;
        if (iPossibleResults == null) {
            return this.v2v(graph, iRecord, ODirection.OUT, iLabels);
        }
        if (!iPossibleResults.iterator().hasNext()) {
            return Collections.emptyList();
        }
        Object edges = this.v2e(graph, iRecord, ODirection.OUT, iLabels);
        if (edges instanceof OSizeable && (size = ((OSizeable)edges).size()) > supernodeThreshold && (result = this.fetchFromIndex(graph, iRecord, iPossibleResults, iLabels)) != null) {
            return result;
        }
        return this.v2v(graph, iRecord, ODirection.OUT, iLabels);
    }

    private Object fetchFromIndex(ODatabase graph, OIdentifiable iFrom, Iterable<OIdentifiable> iTo, String[] iEdgeTypes) {
        String edgeClassName = null;
        if (iEdgeTypes == null) {
            edgeClassName = "E";
        } else if (iEdgeTypes.length == 1) {
            edgeClassName = iEdgeTypes[0];
        } else {
            return null;
        }
        OClass edgeClass = graph.getMetadata().getSchema().getClass(edgeClassName);
        if (edgeClass == null) {
            return null;
        }
        Set<OIndex<?>> indexes = edgeClass.getInvolvedIndexes(NAME, "in");
        if (indexes == null || indexes.size() == 0) {
            return null;
        }
        OIndex<?> index = indexes.iterator().next();
        OMultiCollectionIterator result = new OMultiCollectionIterator();
        for (OIdentifiable to : iTo) {
            OCompositeKey key = new OCompositeKey(iFrom, to);
            Object indexResult = index.get(key);
            if (indexResult instanceof OIdentifiable) {
                indexResult = Collections.singleton(indexResult);
            }
            HashSet<OIdentifiable> identities = new HashSet<OIdentifiable>();
            for (OIdentifiable edge : (Iterable)indexResult) {
                identities.add((OIdentifiable)((ODocument)edge.getRecord()).rawField("in"));
            }
            result.add(identities);
        }
        return result;
    }
}

