/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexFullText;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryTargetOperator;
import java.util.Collection;
import java.util.List;

public class OQueryOperatorContainsText
extends OQueryTargetOperator {
    private boolean ignoreCase = true;

    public OQueryOperatorContainsText(boolean iIgnoreCase) {
        super("CONTAINSTEXT", 5, false);
        this.ignoreCase = iIgnoreCase;
    }

    public OQueryOperatorContainsText() {
        super("CONTAINSTEXT", 5, false);
    }

    @Override
    public String getSyntax() {
        return "<left> CONTAINSTEXT[( noignorecase ] )] <right>";
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext, ODocumentSerializer serializer) {
        if (iLeft == null || iRight == null) {
            return false;
        }
        return iLeft.toString().indexOf(iRight.toString()) > -1;
    }

    @Override
    public Collection<OIdentifiable> filterRecords(ODatabase<?> iDatabase, List<String> iTargetClasses, OSQLFilterCondition iCondition, Object iLeft, Object iRight) {
        String fieldName = iCondition.getLeft() instanceof OSQLFilterItemField ? iCondition.getLeft().toString() : iCondition.getRight().toString();
        String fieldValue = iCondition.getLeft() instanceof OSQLFilterItemField ? iCondition.getRight().toString() : iCondition.getLeft().toString();
        String className = iTargetClasses.get(0);
        OProperty prop = ((OMetadataInternal)iDatabase.getMetadata()).getImmutableSchemaSnapshot().getClass(className).getProperty(fieldName);
        if (prop == null) {
            return null;
        }
        OIndex<?> fullTextIndex = null;
        for (OIndex<?> indexDefinition : prop.getIndexes()) {
            if (!(indexDefinition instanceof OIndexFullText)) continue;
            fullTextIndex = indexDefinition;
            break;
        }
        if (fullTextIndex == null) {
            return null;
        }
        return (Collection)fullTextIndex.get(fieldValue);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        OIndexAbstractCursor cursor;
        OIndexDefinition indexDefinition = index.getDefinition();
        if (indexDefinition.getParamCount() > 1) {
            return null;
        }
        OIndexInternal<?> internalIndex = index.getInternal();
        if (internalIndex instanceof OIndexFullText) {
            Object key = indexDefinition.createValue(keyParams);
            Object indexResult = index.get(key);
            cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, key) : new OIndexCursorCollectionValue((Collection)indexResult, key);
        } else {
            return null;
        }
        this.updateProfiler(iContext, internalIndex, keyParams, indexDefinition);
        return cursor;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

