/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OAlterDatabaseStatement
extends ODDLStatement {
    OIdentifier customPropertyName;
    OExpression customPropertyValue;
    OIdentifier settingName;
    OExpression settingValue;

    public OAlterDatabaseStatement(int id) {
        super(id);
    }

    public OAlterDatabaseStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OInternalResultSet result = new OInternalResultSet();
        if (this.customPropertyName == null) {
            result.add(this.executeSimpleAlter(this.settingName, this.settingValue, ctx));
        } else {
            result.add(this.executeCustomAlter(this.customPropertyName, this.customPropertyValue, ctx));
        }
        return result;
    }

    private OResult executeCustomAlter(OIdentifier customPropertyName, OExpression customPropertyValue, OCommandContext ctx) {
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)ctx.getDatabase();
        db.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_UPDATE, new Object[0]);
        List oldValues = (List)db.get(ODatabase.ATTRIBUTES.CUSTOM);
        String oldValue = null;
        if (oldValues != null) {
            for (OStorageEntryConfiguration entry : oldValues) {
                if (!entry.name.equals(customPropertyName.getStringValue())) continue;
                oldValue = entry.value;
                break;
            }
        }
        Object finalValue = customPropertyValue.execute((OIdentifiable)null, ctx);
        db.setCustom(customPropertyName.getStringValue(), finalValue);
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "alter database");
        result.setProperty("customAttribute", customPropertyName.getStringValue());
        result.setProperty("oldValue", oldValue);
        result.setProperty("newValue", finalValue);
        return result;
    }

    private OResult executeSimpleAlter(OIdentifier settingName, OExpression settingValue, OCommandContext ctx) {
        ODatabase.ATTRIBUTES attribute = ODatabase.ATTRIBUTES.valueOf(settingName.getStringValue().toUpperCase(Locale.ENGLISH));
        ODatabaseDocumentInternal db = (ODatabaseDocumentInternal)ctx.getDatabase();
        db.checkSecurity(ORule.ResourceGeneric.DATABASE, ORole.PERMISSION_UPDATE, new Object[0]);
        Object oldValue = db.get(attribute);
        Object finalValue = settingValue.execute((OIdentifiable)null, ctx);
        db.setInternal(attribute, finalValue);
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "alter database");
        result.setProperty("attribute", settingName.getStringValue());
        result.setProperty("oldValue", oldValue);
        result.setProperty("newValue", finalValue);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("ALTER DATABASE ");
        if (this.customPropertyName != null) {
            builder.append("CUSTOM ");
            this.customPropertyName.toString(params, builder);
            builder.append(" = ");
            this.customPropertyValue.toString(params, builder);
        } else {
            this.settingName.toString(params, builder);
            builder.append(" ");
            this.settingValue.toString(params, builder);
        }
    }

    @Override
    public OAlterDatabaseStatement copy() {
        OAlterDatabaseStatement result = new OAlterDatabaseStatement(-1);
        result.customPropertyName = this.customPropertyName == null ? null : this.customPropertyName.copy();
        result.customPropertyValue = this.customPropertyValue == null ? null : this.customPropertyValue.copy();
        result.settingName = this.settingName == null ? null : this.settingName.copy();
        result.settingValue = this.settingValue == null ? null : this.settingValue.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAlterDatabaseStatement that = (OAlterDatabaseStatement)o;
        if (this.customPropertyName != null ? !this.customPropertyName.equals(that.customPropertyName) : that.customPropertyName != null) {
            return false;
        }
        if (this.customPropertyValue != null ? !this.customPropertyValue.equals(that.customPropertyValue) : that.customPropertyValue != null) {
            return false;
        }
        if (this.settingName != null ? !this.settingName.equals(that.settingName) : that.settingName != null) {
            return false;
        }
        return !(this.settingValue != null ? !this.settingValue.equals(that.settingValue) : that.settingValue != null);
    }

    public int hashCode() {
        int result = this.customPropertyName != null ? this.customPropertyName.hashCode() : 0;
        result = 31 * result + (this.customPropertyValue != null ? this.customPropertyValue.hashCode() : 0);
        result = 31 * result + (this.settingName != null ? this.settingName.hashCode() : 0);
        result = 31 * result + (this.settingValue != null ? this.settingValue.hashCode() : 0);
        return result;
    }
}

