/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.ODeleteExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.ODeleteVertexExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.HashMap;
import java.util.Map;

public class ODeleteVertexStatement
extends OStatement {
    protected boolean from = false;
    protected OFromClause fromClause;
    protected OWhereClause whereClause;
    protected boolean returnBefore = false;
    protected OLimit limit = null;
    protected OBatch batch = null;

    public ODeleteVertexStatement(int id) {
        super(id);
    }

    public ODeleteVertexStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        ODeleteExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : (ODeleteExecutionPlan)this.createExecutionPlanNoCache(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        ODeleteExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : (ODeleteExecutionPlan)this.createExecutionPlanNoCache(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public ODeleteExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        ODeleteVertexExecutionPlanner planner = new ODeleteVertexExecutionPlanner(this);
        ODeleteExecutionPlan result = planner.createExecutionPlan(ctx, enableProfiling);
        result.setStatement(this.originalStatement);
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DELETE VERTEX ");
        if (this.from) {
            builder.append("FROM ");
        }
        this.fromClause.toString(params, builder);
        if (this.returnBefore) {
            builder.append(" RETURN BEFORE");
        }
        if (this.whereClause != null) {
            builder.append(" WHERE ");
            this.whereClause.toString(params, builder);
        }
        if (this.limit != null) {
            this.limit.toString(params, builder);
        }
        if (this.batch != null) {
            this.batch.toString(params, builder);
        }
    }

    @Override
    public ODeleteVertexStatement copy() {
        ODeleteVertexStatement result = new ODeleteVertexStatement(-1);
        result.from = this.from;
        result.fromClause = this.fromClause == null ? null : this.fromClause.copy();
        result.whereClause = this.whereClause == null ? null : this.whereClause.copy();
        result.returnBefore = this.returnBefore;
        result.limit = this.limit == null ? null : this.limit.copy();
        result.batch = this.batch == null ? null : this.batch.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODeleteVertexStatement that = (ODeleteVertexStatement)o;
        if (this.from != that.from) {
            return false;
        }
        if (this.returnBefore != that.returnBefore) {
            return false;
        }
        if (this.fromClause != null ? !this.fromClause.equals(that.fromClause) : that.fromClause != null) {
            return false;
        }
        if (this.whereClause != null ? !this.whereClause.equals(that.whereClause) : that.whereClause != null) {
            return false;
        }
        if (this.limit != null ? !this.limit.equals(that.limit) : that.limit != null) {
            return false;
        }
        return !(this.batch != null ? !this.batch.equals(that.batch) : that.batch != null);
    }

    public int hashCode() {
        int result = this.from ? 1 : 0;
        result = 31 * result + (this.fromClause != null ? this.fromClause.hashCode() : 0);
        result = 31 * result + (this.whereClause != null ? this.whereClause.hashCode() : 0);
        result = 31 * result + (this.returnBefore ? 1 : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.batch != null ? this.batch.hashCode() : 0);
        return result;
    }

    public boolean isFrom() {
        return this.from;
    }

    public void setFrom(boolean from) {
        this.from = from;
    }

    public OFromClause getFromClause() {
        return this.fromClause;
    }

    public void setFromClause(OFromClause fromClause) {
        this.fromClause = fromClause;
    }

    public OWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(OWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    public boolean isReturnBefore() {
        return this.returnBefore;
    }

    public void setReturnBefore(boolean returnBefore) {
        this.returnBefore = returnBefore;
    }

    public OLimit getLimit() {
        return this.limit;
    }

    public void setLimit(OLimit limit) {
        this.limit = limit;
    }

    public OBatch getBatch() {
        return this.batch;
    }

    public void setBatch(OBatch batch) {
        this.batch = batch;
    }
}

