/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.query.OBasicLegacyResultSet;
import com.orientechnologies.orient.core.sql.query.OLiveResultListener;
import com.orientechnologies.orient.core.sql.query.OLocalLiveResultListener;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;

public class OLiveQuery<T>
extends OSQLSynchQuery<T> {
    public OLiveQuery() {
    }

    public OLiveQuery(String iText, OLiveResultListener iResultListener) {
        super(iText);
        this.setResultListener(new OLocalLiveResultListener(iResultListener));
    }

    @Override
    public <RET> RET execute(Object ... iArgs) {
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        if (database.getStorage().isRemote()) {
            BackwardOLiveQueryResultListener listener = new BackwardOLiveQueryResultListener();
            OLiveQueryMonitor monitor = database.live(this.getText(), (OLiveQueryResultListener)listener, iArgs);
            listener.token = monitor.getMonitorId();
            ODocument doc = new ODocument();
            doc.setProperty("token", listener.token);
            OBasicLegacyResultSet result = new OBasicLegacyResultSet();
            result.add(doc);
            return (RET)result;
        }
        return super.execute(iArgs);
    }

    private class BackwardOLiveQueryResultListener
    implements OLiveQueryResultListener {
        protected int token;

        private BackwardOLiveQueryResultListener() {
        }

        @Override
        public void onCreate(ODatabaseDocument database, OResult data) {
            ((OLocalLiveResultListener)OLiveQuery.this.getResultListener()).onLiveResult(this.token, new ORecordOperation(data.toElement(), 3));
        }

        @Override
        public void onUpdate(ODatabaseDocument database, OResult before, OResult after) {
            ((OLocalLiveResultListener)OLiveQuery.this.getResultListener()).onLiveResult(this.token, new ORecordOperation(after.toElement(), 1));
        }

        @Override
        public void onDelete(ODatabaseDocument database, OResult data) {
            ((OLocalLiveResultListener)OLiveQuery.this.getResultListener()).onLiveResult(this.token, new ORecordOperation(data.toElement(), 2));
        }

        @Override
        public void onError(ODatabaseDocument database, OException exception) {
            ((OLocalLiveResultListener)OLiveQuery.this.getResultListener()).onError(this.token);
        }

        @Override
        public void onEnd(ODatabaseDocument database) {
            ((OLocalLiveResultListener)OLiveQuery.this.getResultListener()).onUnsubscribe(this.token);
        }
    }
}

