/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTree;
import com.orientechnologies.orient.core.storage.index.sbtree.multivalue.v2.OMultiValueEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class ONullBucket
extends ODurablePage {
    private static final int EMBEDDED_RIDS_BOUNDARY = 64;
    private static final int RID_SIZE = 10;
    private static final int M_ID_OFFSET = 28;
    private static final int EMBEDDED_RIDS_SIZE_OFFSET = 36;
    private static final int RIDS_SIZE_OFFSET = 37;
    private static final int RIDS_OFFSET = 41;
    private final OSBTree<OMultiValueEntry, Byte> multiContainer;

    ONullBucket(OCacheEntry cacheEntry, OSBTree<OMultiValueEntry, Byte> multiContainer) {
        super(cacheEntry);
        this.multiContainer = multiContainer;
    }

    protected void init(long mId) {
        this.setLongValue(28, mId);
        this.setByteValue(36, (byte)0);
        this.setIntValue(37, 0);
    }

    void addValue(ORID rid) throws IOException {
        byte embeddedSize = this.getByteValue(36);
        if (embeddedSize < 64) {
            int position = embeddedSize * 10 + 41;
            this.setShortValue(position, (short)rid.getClusterId());
            this.setLongValue(position + 2, rid.getClusterPosition());
            this.setByteValue(36, (byte)(embeddedSize + 1));
        } else {
            long mId = this.getLongValue(28);
            this.multiContainer.put(new OMultiValueEntry(mId, rid.getClusterId(), rid.getClusterPosition()), (byte)1);
        }
        int size = this.getIntValue(37);
        this.setIntValue(37, size + 1);
    }

    public List<ORID> getValues() {
        int size = this.getIntValue(37);
        ArrayList<ORID> rids = new ArrayList<ORID>(size);
        byte embeddedSize = this.getByteValue(36);
        int end = embeddedSize * 10 + 41;
        for (int position = 41; position < end; position += 10) {
            short clusterId = this.getShortValue(position);
            long clusterPosition = this.getLongValue(position + 2);
            rids.add(new ORecordId(clusterId, clusterPosition));
        }
        if (size > embeddedSize) {
            long mId = this.getLongValue(28);
            OSBTree.OSBTreeCursor<OMultiValueEntry, Byte> cursor = this.multiContainer.iterateEntriesBetween(new OMultiValueEntry(mId, 0, 0L), true, new OMultiValueEntry(mId + 1L, 0, 0L), false, true);
            Map.Entry<OMultiValueEntry, Byte> mapEntry = cursor.next(-1);
            while (mapEntry != null) {
                OMultiValueEntry entry = mapEntry.getKey();
                rids.add(new ORecordId(entry.clusterId, entry.clusterPosition));
                mapEntry = cursor.next(-1);
            }
        }
        assert (rids.size() == size);
        return rids;
    }

    public int getSize() {
        return this.getIntValue(37);
    }

    boolean removeValue(ORID rid) throws IOException {
        long mId;
        Byte result;
        int size = this.getIntValue(37);
        byte embeddedSize = this.getByteValue(36);
        int end = embeddedSize * 10 + 41;
        for (int position = 41; position < end; position += 10) {
            long clusterPosition;
            short clusterId = this.getShortValue(position);
            if (clusterId != rid.getClusterId() || (clusterPosition = this.getLongValue(position + 2)) != rid.getClusterPosition()) continue;
            this.moveData(position + 10, position, end - (position + 10));
            this.setByteValue(36, (byte)(embeddedSize - 1));
            this.setIntValue(37, size - 1);
            return true;
        }
        if (size > embeddedSize && (result = this.multiContainer.remove(new OMultiValueEntry(mId = this.getLongValue(28), rid.getClusterId(), rid.getClusterPosition()))) != null) {
            this.setIntValue(37, size - 1);
            return true;
        }
        return false;
    }

    int remove() throws IOException {
        long mId = this.getLongValue(28);
        byte embeddedSize = this.getByteValue(36);
        int size = this.getIntValue(37);
        if (size > embeddedSize) {
            ArrayList<OMultiValueEntry> entriesToRemove = new ArrayList<OMultiValueEntry>(size - embeddedSize);
            OSBTree.OSBTreeCursor<OMultiValueEntry, Byte> cursor = this.multiContainer.iterateEntriesBetween(new OMultiValueEntry(mId, 0, 0L), true, new OMultiValueEntry(mId + 1L, 0, 0L), false, true);
            Map.Entry<OMultiValueEntry, Byte> mapEntry = cursor.next(-1);
            while (mapEntry != null) {
                OMultiValueEntry entry = mapEntry.getKey();
                entriesToRemove.add(entry);
                mapEntry = cursor.next(-1);
            }
            for (OMultiValueEntry entry : entriesToRemove) {
                this.multiContainer.remove(entry);
            }
        }
        this.setByteValue(36, (byte)0);
        this.setIntValue(37, 0);
        return size;
    }

    void clear() {
        this.setByteValue(36, (byte)0);
        this.setIntValue(37, 0);
    }

    boolean isEmpty() {
        return this.getIntValue(37) == 0;
    }
}

