/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.conflict;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.conflict.OAbstractDistributedConflictResolver;
import com.orientechnologies.orient.server.distributed.conflict.ODistributedConflictResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OContentDistributedConflictResolver
extends OAbstractDistributedConflictResolver {
    public static final String NAME = "content";

    @Override
    public ODistributedConflictResolver.OConflictResult onConflict(String databaseName, String clusterName, ORecordId rid, ODistributedServerManager dManager, Map<Object, List<String>> candidates) {
        ODistributedConflictResolver.OConflictResult result = new ODistributedConflictResolver.OConflictResult(candidates);
        if (!candidates.isEmpty()) {
            HashMap candidatesGroupedByContent = new HashMap();
            for (Map.Entry<Object, List<String>> entry : candidates.entrySet()) {
                Object object = entry.getKey();
                if (!(object instanceof ORawBuffer)) continue;
                boolean bl = false;
                for (Map.Entry entry2 : candidatesGroupedByContent.entrySet()) {
                    bl = OContentDistributedConflictResolver.compareRecords((ORawBuffer)object, (ORawBuffer)entry2.getKey());
                    if (!bl) continue;
                    ((List)entry2.getValue()).addAll((Collection)entry.getValue());
                    break;
                }
                if (bl) continue;
                candidatesGroupedByContent.put((ORawBuffer)object, entry.getValue());
            }
            if (!candidatesGroupedByContent.isEmpty()) {
                int maxServerList = -1;
                for (Map.Entry entry : candidatesGroupedByContent.entrySet()) {
                    List list = (List)entry.getValue();
                    if (list.size() <= maxServerList) continue;
                    maxServerList = list.size();
                }
                ArrayList winners = new ArrayList();
                for (Map.Entry entry : candidatesGroupedByContent.entrySet()) {
                    List servers = (List)entry.getValue();
                    if (servers.size() != maxServerList) continue;
                    winners.add(entry.getKey());
                }
                if (winners.size() == 1) {
                    int n;
                    ORawBuffer oRawBuffer = (ORawBuffer)winners.get(0);
                    int n2 = -1;
                    for (Map.Entry<Object, Object> entry : candidates.entrySet()) {
                        Object key = entry.getKey();
                        if (!(key instanceof ORawBuffer) || !OContentDistributedConflictResolver.compareRecords(oRawBuffer, (ORawBuffer)key) || ((ORawBuffer)key).version <= n) continue;
                        n = ((ORawBuffer)key).version;
                        result.winner = key;
                    }
                    OLogManager.instance().debug((Object)this, "Content Conflict Resolver decided the value '%s' is the winner for record %s, because the content is the majority. Assigning the highest version (%d)", result.winner, rid, n);
                } else {
                    OLogManager.instance().debug((Object)this, "Content Conflict Resolver cannot decide the winner for record %s, because there is no majority in the content", rid);
                }
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

