/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedStrategy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ODefaultDistributedStrategy
implements ODistributedStrategy {
    @Override
    public void validateConfiguration(ODistributedConfiguration cfg) {
        if (cfg.hasDataCenterConfiguration()) {
            throw new OConfigurationException("Data center configuration is supported only in OrientDB Enterprise Edition");
        }
        if (cfg.isLocalDataCenterWriteQuorum()) {
            throw new OConfigurationException("Quorum of type 'localDataCenter' is supported only in OrientDB Enterprise Edition");
        }
    }

    @Override
    public Set<String> getNodesConcurInQuorum(ODistributedServerManager manager, ODistributedConfiguration cfg, ODistributedRequest request, Collection<String> iNodes, String databaseName, Object localResult) {
        HashSet<String> nodesConcurToTheQuorum = new HashSet<String>();
        if (request.getTask().getQuorumType() == OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE || request.getTask().getQuorumType() == OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE_ALL_MASTERS) {
            for (String node : iNodes) {
                if (cfg.getServerRole(node) != ODistributedConfiguration.ROLES.MASTER) continue;
                nodesConcurToTheQuorum.add(node);
            }
            if (localResult != null && cfg.getServerRole(manager.getLocalNodeName()) == ODistributedConfiguration.ROLES.MASTER) {
                nodesConcurToTheQuorum.add(manager.getLocalNodeName());
            }
        } else {
            nodesConcurToTheQuorum.addAll(iNodes);
            if (localResult != null) {
                nodesConcurToTheQuorum.add(manager.getLocalNodeName());
            }
        }
        return nodesConcurToTheQuorum;
    }
}

