/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.server.distributed.ODistributedLockManager;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.ODistributedLockException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ODistributedLockManagerExecutor
implements ODistributedLockManager {
    private final ODistributedServerManager manager;
    private final ConcurrentHashMap<String, ODistributedLock> lockManager = new ConcurrentHashMap(256);
    private String localNodeName;

    public ODistributedLockManagerExecutor(ODistributedServerManager manager) {
        this.manager = manager;
        this.localNodeName = manager.getLocalNodeName();
    }

    @Override
    public void acquireExclusiveLock(String resource, String nodeSource, long timeout) {
        if (this.localNodeName == null) {
            this.localNodeName = this.manager.getLocalNodeName();
        }
        if (!this.localNodeName.equals(this.manager.getLockManagerServer())) {
            throw new ODistributedLockException("Cannot lock resource '" + resource + "' because current server '" + this.localNodeName + "' is not the lockManager");
        }
        ODistributedLock lock = new ODistributedLock(nodeSource);
        ODistributedLock currentLock = this.lockManager.putIfAbsent(resource, lock);
        if (currentLock != null) {
            if (currentLock.server.equals(nodeSource)) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Resource '%s' already locked by server '%s'", resource, currentLock.server);
                currentLock = null;
            } else {
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        ODistributedServerLog.info((Object)this, this.localNodeName, nodeSource, ODistributedServerLog.DIRECTION.IN, "Server %s is waiting to acquire distributed lock on resource '%s' owned by %s on %s (threadId=%d timeout=%d)...", nodeSource, resource, currentLock.server, new Date(currentLock.acquiredOn), Thread.currentThread().getId(), timeout);
                        if (timeout > 0L) {
                            if (!currentLock.lock.await(timeout, TimeUnit.MILLISECONDS)) {
                                continue;
                            }
                        } else {
                            currentLock.lock.await();
                        }
                        currentLock = this.lockManager.putIfAbsent(resource, lock);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                } while (currentLock != null && (timeout == 0L || System.currentTimeMillis() - startTime < timeout));
            }
        }
        if (!(currentLock == null || currentLock.server != null && this.manager.isNodeAvailable(currentLock.server))) {
            ODistributedServerLog.info((Object)this, this.localNodeName, null, ODistributedServerLog.DIRECTION.NONE, "Forcing unlock of resource '%s' because the owner server '%s' is offline", resource, currentLock.server);
            this.lockManager.put(resource, lock);
            currentLock = null;
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            if (currentLock == null) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, nodeSource, ODistributedServerLog.DIRECTION.IN, "Resource '%s' locked by server '%s' (threadId=%d)", resource, nodeSource, Thread.currentThread().getId());
            } else {
                ODistributedServerLog.debug((Object)this, this.localNodeName, nodeSource, ODistributedServerLog.DIRECTION.IN, "Cannot lock resource '%s' owned by server '%s' (timeout=%d threadId=%d)", resource, currentLock.server, timeout, Thread.currentThread().getId());
            }
        }
        if (currentLock != null) {
            throw new ODistributedLockException("Cannot lock resource '" + resource + "' owned by server '" + currentLock.server + "' (timeout=" + timeout + " threadId=" + Thread.currentThread().getId() + ")");
        }
    }

    @Override
    public void releaseExclusiveLock(String resource, String nodeSource) {
        ODistributedLock owner;
        if (resource == null) {
            return;
        }
        if (this.localNodeName == null) {
            this.localNodeName = this.manager.getLocalNodeName();
        }
        if ((owner = this.lockManager.remove(resource)) != null) {
            if (!owner.server.equals(nodeSource)) {
                ODistributedServerLog.error((Object)this, this.localNodeName, nodeSource, ODistributedServerLog.DIRECTION.IN, "Cannot unlock resource %s because owner server '%s' <> current '%s'", resource, owner.server, this.localNodeName);
                return;
            }
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, this.localNodeName, owner.server, ODistributedServerLog.DIRECTION.IN, "Unlocked resource '%s' (owner=%s elapsed=%s)", resource, owner.server, System.currentTimeMillis() - owner.acquiredOn);
            }
            owner.lock.countDown();
        }
    }

    @Override
    public void handleUnreachableServer(String nodeLeftName) {
        ArrayList<String> unlockedResources = new ArrayList<String>();
        Iterator<Map.Entry<String, ODistributedLock>> it = this.lockManager.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ODistributedLock> entry = it.next();
            ODistributedLock lock = entry.getValue();
            if (lock == null || lock.server == null || !lock.server.equals(nodeLeftName)) continue;
            OLogManager.instance().info((Object)this, "Forcing unlocking resource '%s' acquired by '%s'", entry.getKey(), lock.server);
            unlockedResources.add(entry.getKey());
            it.remove();
            lock.lock.countDown();
        }
        if (unlockedResources.size() > 0) {
            ODistributedServerLog.info((Object)this, this.localNodeName, nodeLeftName, ODistributedServerLog.DIRECTION.IN, "Forced unlocked %d resources %s owned by server '%s'", unlockedResources.size(), unlockedResources, nodeLeftName);
        }
    }

    public String dumpLocks() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("HA RESOURCE LOCKS FOR SERVER '" + this.localNodeName + "'");
        long now = System.currentTimeMillis();
        for (Map.Entry<String, ODistributedLock> entry : this.lockManager.entrySet()) {
            buffer.append("\n  - '" + entry.getKey() + "' by server " + entry.getValue().server + " (acquiredOn=" + (now - entry.getValue().acquiredOn) + "ms ago - count=" + entry.getValue().lock.getCount() + ")");
        }
        return buffer.toString();
    }

    @Override
    public void shutdown() {
        Iterator<Map.Entry<String, ODistributedLock>> it = this.lockManager.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, ODistributedLock> entry = it.next();
            ODistributedLock lock = entry.getValue();
            it.remove();
            lock.lock.countDown();
        }
    }

    private class ODistributedLock {
        final String server;
        final CountDownLatch lock;
        final long acquiredOn;

        private ODistributedLock(String server) {
            this.server = server;
            this.lock = new CountDownLatch(1);
            this.acquiredOn = System.currentTimeMillis();
        }
    }
}

