/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.cluster.OPaginatedCluster;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class OCreateRecordTask
extends OAbstractRecordReplicatedTask {
    public static final int FACTORYID = 0;
    protected byte[] content;
    protected byte recordType;
    protected int clusterId = -1;
    private transient ORecord record;

    public OCreateRecordTask init(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        super.init(iRid, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
        return this;
    }

    @Override
    public OCreateRecordTask init(ORecord record) {
        this.init((ORecordId)record.getIdentity(), record.toStream(), record.getVersion() - 1, ORecordInternal.getRecordType(record));
        if (this.rid.getClusterId() == -1) {
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
            this.clusterId = db.assignAndCheckCluster(record, null);
            ((ORecordId)record.getIdentity()).setClusterId(-1);
        }
        return this;
    }

    @Override
    public ORecord prepareUndoOperation() {
        return null;
    }

    @Override
    public void checkRecordExists() {
    }

    @Override
    public ORecord getRecord() {
        if (this.record == null) {
            this.record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType, this.rid.getClusterId(), ODatabaseRecordThreadLocal.instance().get());
            ORecordInternal.fill(this.record, this.rid, this.version, this.content, true);
        }
        return this.record;
    }

    @Override
    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Creating record %s/%s v.%d reqId=%s...", database.getName(), this.rid.toString(), this.version, requestId);
        }
        if (!this.rid.isPersistent()) {
            throw new ODistributedException("Record " + this.rid + " has not been saved on owner node first (temporary rid)");
        }
        OPaginatedCluster cluster = (OPaginatedCluster)ODatabaseRecordThreadLocal.instance().get().getStorage().getClusterById(this.rid.getClusterId());
        OPaginatedCluster.RECORD_STATUS recordStatus = cluster.getRecordStatus(this.rid.getClusterPosition());
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Found record %s/%s status=%s reqId=%s...", new Object[]{database.getName(), this.rid.toString(), recordStatus, requestId});
        }
        switch (recordStatus) {
            case REMOVED: {
                this.getRecord();
                ODatabaseRecordThreadLocal.instance().get().recycle(this.record);
            }
            case ALLOCATED: {
                this.getRecord();
                if (this.record.getVersion() < 0) {
                    ORecordInternal.setVersion(this.record, this.record.getVersion() + 1);
                }
                this.record.save();
                break;
            }
            case PRESENT: {
                this.getRecord();
                this.record.save();
                break;
            }
            case NOT_EXISTENT: {
                ORecordId newRid;
                do {
                    this.getRecord();
                    if (this.clusterId > -1) {
                        this.record.save(database.getClusterNameById(this.clusterId), true);
                    } else if (this.rid.getClusterId() != -1) {
                        this.record.save(database.getClusterNameById(this.rid.getClusterId()), true);
                    } else {
                        this.record.save();
                    }
                    newRid = (ORecordId)this.record.getIdentity();
                    if (newRid.getClusterPosition() >= this.rid.getClusterPosition()) break;
                    this.record.delete();
                    this.record = null;
                } while (newRid.getClusterPosition() < this.rid.getClusterPosition());
                if (!this.rid.equals(newRid)) {
                    ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Record %s has been saved with the RID %s instead of the expected %s reqId=%s", this.record, newRid, this.rid, requestId);
                    this.record.delete();
                    throw new ODistributedException("Record " + this.rid + " has been saved with the different RID " + newRid + " on server " + iManager.getLocalNodeName());
                }
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> assigning new rid %s/%s v.%d reqId=%s", database.getName(), this.rid.toString(), this.record.getVersion(), requestId);
            }
        }
        return new OPlaceholder(this.record);
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNode, ODistributedServerManager dManager) {
        if (iBadResponse == null || iBadResponse instanceof Throwable && !(iBadResponse instanceof ONeedRetryException)) {
            return null;
        }
        OAbstractRecordReplicatedTask result = null;
        OPlaceholder goodResult = (OPlaceholder)iGoodResponse;
        if (iBadResponse instanceof ONeedRetryException) {
            return ((OCreateRecordTask)dManager.getTaskFactoryManager().getFactoryByServerName(executorNode).createTask(0)).init((ORecordId)goodResult.getIdentity(), this.content, ORecordVersionHelper.setRollbackMode(this.version), this.recordType);
        }
        OPlaceholder badResult = (OPlaceholder)iBadResponse;
        if (!badResult.equals(goodResult)) {
            if (badResult.getIdentity().getClusterId() == goodResult.getIdentity().getClusterId() && badResult.getIdentity().getClusterPosition() < goodResult.getIdentity().getClusterPosition()) {
                long minPos;
                for (long pos = minPos = Math.max(badResult.getIdentity().getClusterPosition() - 1L, 0L); pos < goodResult.getIdentity().getClusterPosition(); ++pos) {
                    Object toUpdateRecord;
                    ORecordId toUpdateRid = new ORecordId(goodResult.getIdentity().getClusterId(), pos);
                    if (dManager.getLocalNodeName().equals(executorNode)) {
                        ODistributedConfiguration dCfg = dManager.getDatabaseConfiguration(iRequest.getDatabaseName());
                        List<String> nodes = dCfg.getServers(ODatabaseRecordThreadLocal.instance().get().getClusterNameById(this.clusterId), dManager.getLocalNodeName());
                        OReadRecordTask task = (OReadRecordTask)dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(1);
                        task.init(toUpdateRid);
                        ODistributedResponse response = dManager.sendRequest(iRequest.getDatabaseName(), null, nodes, task, dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                        ORawBuffer remoteReadRecord = (ORawBuffer)response.getPayload();
                        if (remoteReadRecord != null) {
                            toUpdateRecord = Orient.instance().getRecordFactoryManager().newInstance(this.recordType, this.record.getIdentity().getClusterId(), ODatabaseRecordThreadLocal.instance().get());
                            ORecordInternal.fill(toUpdateRecord, toUpdateRid, remoteReadRecord.version, remoteReadRecord.buffer, false);
                        } else {
                            toUpdateRecord = null;
                        }
                    } else {
                        toUpdateRecord = toUpdateRid.getRecord();
                    }
                    if (toUpdateRecord == null) continue;
                    try {
                        new OFixUpdateRecordTask().init(toUpdateRid, toUpdateRecord.toStream(), toUpdateRecord.getVersion(), ORecordInternal.getRecordType(toUpdateRecord)).execute(iRequest.getId(), dManager.getServerInstance(), dManager, ODatabaseRecordThreadLocal.instance().get());
                        continue;
                    }
                    catch (Exception e) {
                        throw OException.wrapException(new ODistributedOperationException("Cannot create record " + this.rid + " because assigned RID is different"), e);
                    }
                }
                OCreateRecordTask task = (OCreateRecordTask)dManager.getTaskFactoryManager().getFactoryByServerName(executorNode).createTask(0);
                task.init((ORecordId)goodResult.getIdentity(), this.content, this.version, this.recordType);
                result = task;
            } else if (badResult.getIdentity().getClusterId() != goodResult.getIdentity().getClusterId() || badResult.getIdentity().getClusterPosition() <= goodResult.getIdentity().getClusterPosition()) {
                OFixCreateRecordTask task = (OFixCreateRecordTask)dManager.getTaskFactoryManager().getFactoryByServerName(executorNode).createTask(20);
                task.init(new ORecordId(badResult.getIdentity()), badResult.getVersion());
                result = task;
            }
        }
        return result;
    }

    @Override
    public ODeleteRecordTask getUndoTask(ODistributedServerManager dManager, ODistributedRequestId reqId, List<String> servers) {
        ODeleteRecordTask task = (ODeleteRecordTask)dManager.getTaskFactoryManager().getFactoryByServerNames(servers).createTask(4);
        task.init(this.rid, -1);
        task.setLockRecords(false);
        return task;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        if (this.content == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.content.length);
            out.write(this.content);
        }
        out.writeByte(this.recordType);
        out.writeInt(this.clusterId);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        super.fromStream(in, factory);
        int contentSize = in.readInt();
        if (contentSize == 0) {
            this.content = null;
        } else {
            this.content = new byte[contentSize];
            in.readFully(this.content);
        }
        this.recordType = in.readByte();
        this.clusterId = in.readInt();
    }

    @Override
    public String getName() {
        return "record_create";
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }
}

