/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.ORetryQueryException;
import com.orientechnologies.orient.core.serialization.OStreamableHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.filter.OSQLTarget;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractCommandTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OSQLCommandTask
extends OAbstractCommandTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 5;
    protected String text;
    protected Map<Object, Object> params;
    protected ORemoteTask.RESULT_STRATEGY resultStrategy;
    protected Collection<String> clusters;
    protected OCommandDistributedReplicateRequest.QUORUM_TYPE quorumType;
    protected long timeout;
    protected boolean idempotent;

    public OSQLCommandTask() {
        this.clusters = new HashSet<String>();
    }

    public OSQLCommandTask(OCommandRequestText iCommand, Collection<String> iClusterNames) {
        this.clusters = iClusterNames;
        this.text = iCommand.getText();
        this.params = iCommand.getParameters();
        OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
        executor.parse(iCommand);
        this.quorumType = ((OCommandDistributedReplicateRequest)((Object)executor)).getQuorumType();
        this.timeout = executor.getDistributedTimeout();
        this.idempotent = executor.isIdempotent();
    }

    @Override
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        Object res;
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Execute command=%s db=%s", this.text.toString(), database.getName());
        }
        while (true) {
            try {
                OCommandExecutor exec;
                Object cmd = database.command(new OCommandSQL(this.text));
                OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)cmd);
                executor.parse((OCommandRequest)cmd);
                OCommandExecutor oCommandExecutor = exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
                if (exec instanceof OCommandExecutorSQLSelect && this.clusters.size() > 0) {
                    StringBuilder buffer = new StringBuilder("cluster:[");
                    int i = 0;
                    for (String c : this.clusters) {
                        if (i++ > 0) {
                            buffer.append(',');
                        }
                        buffer.append(c);
                    }
                    buffer.append("]");
                    ((OCommandExecutorSQLSelect)exec).setParsedTarget(new OSQLTarget(buffer.toString(), exec.getContext()));
                }
                if (this.params != null) {
                    res = executor.execute(this.params);
                    break;
                }
                res = executor.execute(null);
            }
            catch (ORetryQueryException e) {
                continue;
            }
            break;
        }
        return res;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return this.quorumType;
    }

    @Override
    public ORemoteTask.RESULT_STRATEGY getResultStrategy() {
        return this.resultStrategy;
    }

    @Override
    public void setResultStrategy(ORemoteTask.RESULT_STRATEGY resultStrategy) {
        this.resultStrategy = resultStrategy;
    }

    @Override
    public long getDistributedTimeout() {
        return this.timeout;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        out.writeUTF(this.text);
        OStreamableHelper.toStream(out, this.params);
        out.writeInt(this.clusters.size());
        for (String c : this.clusters) {
            out.writeUTF(c);
        }
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.text = in.readUTF();
        this.params = (Map)OStreamableHelper.fromStream(in);
        int cSize = in.readInt();
        this.clusters = new HashSet<String>(cSize);
        for (int i = 0; i < cSize; ++i) {
            this.clusters.add(in.readUTF());
        }
    }

    @Override
    public String getName() {
        return "command_sql";
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.text + ")";
    }

    @Override
    public ORemoteTask getUndoTask(ODistributedServerManager dManager, ODistributedRequestId reqId, List<String> servers) {
        String undoCommand;
        Object cmd = ODatabaseRecordThreadLocal.instance().get().command(new OCommandSQL(this.text));
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)cmd);
        executor.parse((OCommandRequest)cmd);
        if (executor instanceof OCommandExecutorSQLDelegate) {
            executor = ((OCommandExecutorSQLDelegate)executor).getDelegate();
        }
        if (executor instanceof OCommandDistributedReplicateRequest && (undoCommand = ((OCommandDistributedReplicateRequest)((Object)executor)).getUndoCommand()) != null) {
            OSQLCommandTask undoTask = new OSQLCommandTask(new OCommandSQL(undoCommand), this.clusters);
            undoTask.setResultStrategy(this.resultStrategy);
            return undoTask;
        }
        return super.getUndoTask(dManager, reqId, servers);
    }

    @Override
    public boolean isIdempotent() {
        return this.idempotent;
    }

    @Override
    public int getFactoryId() {
        return 5;
    }
}

