/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;

public class OStopServerTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 9;

    @Override
    public Object execute(ODistributedRequestId requestId, final OServer iServer, final ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.warn((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Stopping current server...", new Object[0]);
        Orient.instance().scheduleTask(new Runnable(){

            @Override
            public void run() {
                try {
                    iServer.shutdown();
                }
                catch (Exception e) {
                    ODistributedServerLog.error((Object)this, iManager.getLocalNodeName(), OStopServerTask.this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Error on stopping current server", e, new Object[0]);
                }
            }
        }, 1L, 0L);
        return true;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    @Override
    public String getName() {
        return "stop_server";
    }

    @Override
    public int getFactoryId() {
        return 9;
    }

    @Override
    public boolean isUsingDatabase() {
        return false;
    }
}

