/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OSyncSource;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedMomentum;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.task.OAbstractSyncDatabaseTask;
import com.orientechnologies.orient.server.distributed.impl.task.OBackgroundBackup;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class OSyncDatabaseTask
extends OAbstractSyncDatabaseTask {
    public static final int FACTORYID = 14;

    public OSyncDatabaseTask() {
    }

    public OSyncDatabaseTask(OLogSequenceNumber lastLSN, long lastOperationTimestamp) {
        super(lastOperationTimestamp);
        this.lastLSN = lastLSN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (!iManager.getLocalNodeName().equals(this.getNodeSource())) {
            if (database == null) {
                throw new ODistributedException("Database instance is null");
            }
            String databaseName = database.getName();
            ODistributedDatabase dDatabase = this.checkIfCurrentDatabaseIsNotOlder(iManager, databaseName, database);
            try {
                Long lastDeployment = (Long)iManager.getConfigurationMap().get("deploydb." + databaseName);
                if (lastDeployment != null && lastDeployment == this.random) {
                    ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "Skip deploying database '%s' because already executed", databaseName);
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                iManager.getConfigurationMap().put("deploydb." + databaseName, this.random);
                iManager.setDatabaseStatus(this.getNodeSource(), databaseName, ODistributedServerManager.DB_STATUS.SYNCHRONIZING);
                ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "Deploying database %s...", databaseName);
                AtomicReference<ODistributedMomentum> momentum = new AtomicReference<ODistributedMomentum>();
                OBackgroundBackup backup = null;
                OSyncSource last = ((ODistributedStorage)database.getStorage()).getLastValidBackup();
                if (last instanceof OBackgroundBackup) {
                    backup = (OBackgroundBackup)last;
                }
                if (backup == null || !last.isValid() || !backup.getResultedBackupFile().exists()) {
                    File backupFile = new File(Orient.getTempPath() + "/backup_" + database.getName() + ".zip");
                    String backupPath = backupFile.getAbsolutePath();
                    int compressionRate = OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION.getValueAsInteger();
                    if (backupFile.exists()) {
                        if (backupFile.isDirectory()) {
                            OFileUtils.deleteRecursively(backupFile);
                        }
                        backupFile.delete();
                    } else {
                        backupFile.getParentFile().mkdirs();
                    }
                    backupFile.createNewFile();
                    File resultedBackupFile = backupFile;
                    File completedFile = new File(backupFile.getAbsolutePath() + ".completed");
                    if (completedFile.exists()) {
                        completedFile.delete();
                    }
                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "Creating backup of database '%s' (compressionRate=%d) in directory: %s...", databaseName, compressionRate, backupPath);
                    backup = new OBackgroundBackup(this, iManager, database, resultedBackupFile, backupPath, null, momentum, dDatabase, requestId, completedFile);
                    Thread t = new Thread(backup);
                    t.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
                    t.start();
                    ((ODistributedStorage)database.getStorage()).setLastValidBackup(backup);
                } else {
                    momentum.set(dDatabase.getSyncConfiguration().getMomentum().copy());
                    backup.makeStreamFromFile();
                    ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "Reusing last backup of database '%s' in directory: %s...", databaseName, backup.getResultedBackupFile().getAbsolutePath());
                }
                for (int retry = 0; momentum.get() == null && retry < 10; ++retry) {
                    Thread.sleep(300L);
                }
                while (!backup.getStarted().await(1L, TimeUnit.MINUTES)) {
                    OLogManager.instance().info((Object)this, "Another backup running on database '%s' waiting it to finish", databaseName);
                }
                ODistributedDatabaseChunk chunk = new ODistributedDatabaseChunk(backup, 0x800000, (ODistributedMomentum)momentum.get());
                ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "- transferring chunk #%d offset=%d size=%s lsn=%s...", 1, 0, OFileUtils.getSizeAsNumber(chunk.buffer.length), momentum.get());
                if (chunk.last) {
                    iManager.setDatabaseStatus(iManager.getLocalNodeName(), databaseName, ODistributedServerManager.DB_STATUS.ONLINE);
                }
                ODistributedDatabaseChunk oDistributedDatabaseChunk = chunk;
                return oDistributedDatabaseChunk;
            }
            catch (OLockException e) {
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "Skip deploying database %s because another node is doing it", databaseName);
            }
            finally {
                ODistributedServerLog.info((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.OUT, "Deploy database task completed", new Object[0]);
            }
        } else {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.NONE, "Skip deploying database from the same node", new Object[0]);
        }
        return Boolean.FALSE;
    }

    protected ODistributedDatabase checkIfCurrentDatabaseIsNotOlder(ODistributedServerManager iManager, String databaseName, ODatabaseDocumentInternal database) {
        OLogSequenceNumber currentLSN;
        ODistributedDatabase dDatabase = iManager.getMessageService().getDatabase(databaseName);
        if (this.lastLSN != null && (currentLSN = ((OAbstractPaginatedStorage)database.getStorage().getUnderlying()).getLSN()) != null && this.lastLSN.compareTo(currentLSN) <= 0) {
            return dDatabase;
        }
        if (this.lastOperationTimestamp > -1L) {
            if (this.lastOperationTimestamp <= dDatabase.getSyncConfiguration().getLastOperationTimestamp()) {
                return dDatabase;
            }
        } else {
            return dDatabase;
        }
        return this.databaseIsOld(iManager, databaseName, dDatabase);
    }

    @Override
    public String getName() {
        return "deploy_db";
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        this.writeOptionalLSN(out);
        out.writeLong(this.random);
        out.writeLong(this.lastOperationTimestamp);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        this.readOptionalLSN(in);
        this.random = in.readLong();
        this.lastOperationTimestamp = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return 14;
    }
}

