/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OFixUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class OUpdateRecordTask
extends OAbstractRecordReplicatedTask {
    private static final long serialVersionUID = 1L;
    public static final int FACTORYID = 3;
    protected byte recordType;
    protected byte[] content;
    private transient ORecord record;
    private byte[] previousRecordContent;
    private int previousRecordVersion;

    @Override
    public OUpdateRecordTask init(ORecord iRecord) {
        super.init((ORecordId)iRecord.getIdentity(), iRecord.getVersion() - 1);
        this.content = iRecord.toStream();
        this.recordType = ORecordInternal.getRecordType(iRecord);
        return this;
    }

    public OUpdateRecordTask init(ORecord iRecord, int version) {
        super.init((ORecordId)iRecord.getIdentity(), version);
        this.content = iRecord.toStream();
        this.recordType = ORecordInternal.getRecordType(iRecord);
        return this;
    }

    public OUpdateRecordTask init(ORecordId iRecordId, byte[] iContent, int iVersion, byte iRecordType) {
        super.init(iRecordId, iVersion);
        this.content = iContent;
        this.recordType = iRecordType;
        return this;
    }

    @Override
    public ORecord getRecord() {
        if (this.record == null) {
            this.record = Orient.instance().getRecordFactoryManager().newInstance(this.recordType, this.rid.getClusterId(), ODatabaseRecordThreadLocal.instance().get());
            ORecordInternal.fill(this.record, this.rid, this.version, this.content, true);
        }
        return this.record;
    }

    @Override
    public Object executeRecordTask(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "Updating record %s/%s v.%d reqId=%s...", database.getName(), this.rid.toString(), this.version, requestId);
        }
        this.prepareUndoOperation();
        if (this.previousRecord == null) {
            OPlaceholder ph = (OPlaceholder)new OCreateRecordTask().init(this.rid, this.content, this.version, this.recordType).executeRecordTask(requestId, iServer, iManager, database);
            this.record = ph.getRecord();
            if (this.record == null) {
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> Error on updating record %s", this.rid);
            }
        } else {
            ORecord loadedRecord = this.previousRecord;
            if (loadedRecord instanceof ODocument) {
                ODocument newDocument = (ODocument)this.getRecord();
                ODocument loadedDocument = (ODocument)loadedRecord;
                loadedDocument.merge(newDocument, false, false).getVersion();
                ORecordInternal.setVersion(loadedDocument, this.version);
            } else {
                ORecordInternal.fill(loadedRecord, this.rid, this.version, this.content, true);
            }
            loadedRecord.setDirty();
            this.record = (ORecord)database.save(loadedRecord);
            if (this.record == null) {
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> Error on updating record %s", this.rid);
            }
            if (this.version < 0 && ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> Reverted %s from version %d to %d", this.rid, this.previousRecordVersion, this.record.getVersion());
            }
        }
        if (this.record == null) {
            throw new ODistributedException("Cannot update record " + this.rid);
        }
        if (ODistributedServerLog.isDebugEnabled()) {
            ODistributedServerLog.debug((Object)this, iManager.getLocalNodeName(), this.getNodeSource(), ODistributedServerLog.DIRECTION.IN, "+-> updated record %s/%s v.%d [%s]", database.getName(), this.rid.toString(), this.record.getVersion(), this.record);
        }
        return this.record.getVersion();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        if (iGoodResponse instanceof Integer) {
            int versionCopy = ORecordVersionHelper.setRollbackMode((Integer)iGoodResponse);
            return ((OFixUpdateRecordTask)dManager.getTaskFactoryManager().getFactoryByServerName(executorNodeName).createTask(21)).init(this.rid, this.content, versionCopy, this.recordType);
        }
        if (iGoodResponse instanceof ORecord) {
            ORecord goodRecord = (ORecord)iGoodResponse;
            int versionCopy = ORecordVersionHelper.setRollbackMode(goodRecord.getVersion());
            return ((OFixUpdateRecordTask)dManager.getTaskFactoryManager().getFactoryByServerName(executorNodeName).createTask(21)).init(this.rid, goodRecord.toStream(), versionCopy, this.recordType);
        }
        return null;
    }

    @Override
    public ORemoteTask getUndoTask(ODistributedServerManager dManager, ODistributedRequestId reqId, List<String> servers) {
        if (this.previousRecord == null) {
            return null;
        }
        int versionCopy = ORecordVersionHelper.setRollbackMode(this.previousRecordVersion);
        OFixUpdateRecordTask task = ((OFixUpdateRecordTask)dManager.getTaskFactoryManager().getFactoryByServerNames(servers).createTask(21)).init(this.rid, this.previousRecordContent, versionCopy, this.recordType);
        task.setLockRecords(false);
        return task;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        super.toStream(out);
        out.writeInt(this.content.length);
        out.write(this.content);
        out.writeByte(this.recordType);
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        super.fromStream(in, factory);
        int contentSize = in.readInt();
        this.content = new byte[contentSize];
        in.readFully(this.content);
        this.recordType = in.readByte();
    }

    @Override
    public String getName() {
        return "record_update";
    }

    @Override
    public String toString() {
        if (ORecordVersionHelper.isTemporary(this.version)) {
            return this.getName() + "(" + this.rid + " v." + (this.version - Integer.MIN_VALUE) + " realV." + this.version + ")";
        }
        return super.toString();
    }

    public byte[] getContent() {
        return this.content;
    }

    @Override
    public int getFactoryId() {
        return 3;
    }

    @Override
    public ORecord prepareUndoOperation() {
        if (this.previousRecord == null) {
            OStorageOperationResult<ORawBuffer> loaded = ODatabaseRecordThreadLocal.instance().get().getStorage().getUnderlying().readRecord(this.rid, null, true, false, null);
            if (loaded == null || loaded.getResult() == null) {
                return null;
            }
            this.previousRecordContent = loaded.getResult().buffer;
            this.previousRecordVersion = loaded.getResult().version;
            this.previousRecord = Orient.instance().getRecordFactoryManager().newInstance(loaded.getResult().recordType, this.rid.getClusterId(), ODatabaseRecordThreadLocal.instance().get());
            ORecordInternal.fill(this.previousRecord, this.rid, this.previousRecordVersion, loaded.getResult().getBuffer(), false);
        }
        return this.previousRecord;
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }
}

