/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientStandardGraph;

public class OrientFactory {
    public static OrientStandardGraph open() {
        return OrientFactory.open("memory:orientdb-" + Math.random(), "admin", "admin");
    }

    public static OrientStandardGraph open(String url) {
        return OrientFactory.open(url, "admin", "admin");
    }

    public static OrientStandardGraph open(String url, String user, String password) {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty("orient-url", url);
        configuration.setProperty("orient-user", user);
        configuration.setProperty("orient-pass", password);
        return OrientFactory.open(configuration);
    }

    public static OrientStandardGraph open(Configuration config) {
        boolean transactional = config.getBoolean("orient-transactional", true);
        config.setProperty("orient-transactional", transactional);
        OrientGraphFactory factory = new OrientGraphFactory(config);
        return new OrientStandardGraph(factory, config);
    }
}

