/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.executor;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.script.transformer.OScriptTransformer;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OQueryMetrics;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;

public class OGremlinScriptResultSet
implements OResultSet,
OQueryMetrics {
    private final String textTraversal;
    protected Traversal traversal;
    private OScriptTransformer transformer;
    private boolean closeGraph;
    private boolean closing = false;
    long startTime = 0L;
    long totalExecutionTime = 0L;
    boolean first = true;

    public OGremlinScriptResultSet(String iText, Traversal traversal, OScriptTransformer transformer) {
        this(iText, traversal, transformer, false);
    }

    public OGremlinScriptResultSet(String iText, Traversal traversal, OScriptTransformer transformer, boolean closeGraph) {
        this.textTraversal = iText;
        this.traversal = traversal;
        this.transformer = transformer;
        this.closeGraph = closeGraph;
    }

    @Override
    public boolean hasNext() {
        return this.traversal.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResult next() {
        long begin = System.currentTimeMillis();
        if (this.first) {
            this.first = false;
            this.startTime = begin;
        }
        try {
            Object next = this.traversal.next();
            OResult oResult = this.transformer.toResult(next);
            return oResult;
        }
        finally {
            this.totalExecutionTime += System.currentTimeMillis() - begin;
        }
    }

    @Override
    public void close() {
        try {
            this.traversal.close();
            if (this.closeGraph) {
                this.traversal.asAdmin().getGraph().ifPresent(graph -> {
                    try {
                        OrientGraph g = (OrientGraph)graph;
                        if (!this.closing) {
                            this.closing = true;
                            g.close();
                        }
                    }
                    catch (Exception e) {
                        throw OException.wrapException(new OCommandExecutionException("Error closing the Graph "), e);
                    }
                });
            }
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error closing the gremlin Result Set"), e);
        }
    }

    @Override
    public Optional<OExecutionPlan> getExecutionPlan() {
        return Optional.empty();
    }

    @Override
    public Map<String, Long> getQueryStats() {
        return null;
    }

    @Override
    public String getStatement() {
        return this.textTraversal;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getElapsedTimeMillis() {
        return this.totalExecutionTime;
    }

    @Override
    public String getLanguage() {
        return "gremlin";
    }
}

