/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.Comparator;
import java.util.Random;

public enum Order implements Comparator<Object>
{
    incr{

        @Override
        public int compare(Object first, Object second) {
            return Comparator.naturalOrder().compare((Comparable)first, (Comparable)second);
        }

        @Override
        public Order reversed() {
            return decr;
        }
    }
    ,
    decr{

        @Override
        public int compare(Object first, Object second) {
            return Comparator.reverseOrder().compare((Comparable)first, (Comparable)second);
        }

        @Override
        public Order reversed() {
            return incr;
        }
    }
    ,
    shuffle{

        @Override
        public int compare(Object first, Object second) {
            return RANDOM.nextBoolean() ? -1 : 1;
        }

        @Override
        public Order reversed() {
            return shuffle;
        }
    };

    private static final Random RANDOM;

    @Override
    public abstract int compare(Object var1, Object var2);

    public abstract Order reversed();

    static {
        RANDOM = new Random();
    }
}

