/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Mutating;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.ListCallbackRegistry;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedFactory;

public final class DropStep<S>
extends FilterStep<S>
implements Mutating<Event> {
    private CallbackRegistry<Event> callbackRegistry;

    public DropStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        Object s = traverser.get();
        if (s instanceof Element) {
            Element toRemove = (Element)s;
            if (this.callbackRegistry != null) {
                Event removeEvent;
                if (s instanceof Vertex) {
                    removeEvent = new Event.VertexRemovedEvent(DetachedFactory.detach((Vertex)s, true));
                } else if (s instanceof Edge) {
                    removeEvent = new Event.EdgeRemovedEvent(DetachedFactory.detach((Edge)s, true));
                } else if (s instanceof VertexProperty) {
                    removeEvent = new Event.VertexPropertyRemovedEvent(DetachedFactory.detach((VertexProperty)s, true));
                } else {
                    throw new IllegalStateException("The incoming object is not removable: " + s);
                }
                this.callbackRegistry.getCallbacks().forEach(c -> c.accept(removeEvent));
            }
            toRemove.remove();
        } else if (s instanceof Property) {
            Property toRemove = (Property)s;
            if (this.callbackRegistry != null) {
                Event.ElementPropertyEvent removeEvent;
                if (toRemove.element() instanceof Edge) {
                    removeEvent = new Event.EdgePropertyRemovedEvent((Edge)toRemove.element(), DetachedFactory.detach(toRemove));
                } else if (toRemove.element() instanceof VertexProperty) {
                    removeEvent = new Event.VertexPropertyPropertyRemovedEvent((VertexProperty)toRemove.element(), DetachedFactory.detach(toRemove));
                } else {
                    throw new IllegalStateException("The incoming object is not removable: " + s);
                }
                this.callbackRegistry.getCallbacks().forEach(c -> c.accept(removeEvent));
            }
            toRemove.remove();
        } else {
            throw new IllegalStateException("The incoming object is not removable: " + s);
        }
        return false;
    }

    @Override
    public CallbackRegistry<Event> getMutatingCallbackRegistry() {
        if (null == this.callbackRegistry) {
            this.callbackRegistry = new ListCallbackRegistry<Event>();
        }
        return this.callbackRegistry;
    }

    @Override
    public void addPropertyMutations(Object ... keyValues) {
    }
}

