/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonTypeInfo;
import org.apache.tinkerpop.shaded.jackson.core.type.TypeReference;
import org.apache.tinkerpop.shaded.jackson.databind.DatabindContext;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeIdResolver;
import org.apache.tinkerpop.shaded.jackson.databind.type.TypeFactory;

public class GraphSONTypeIdResolver
implements TypeIdResolver {
    private final Map<String, JavaType> idToType = new HashMap<String, JavaType>();
    private final Map<Class, String> typeToId = new HashMap<Class, String>();

    public Map<String, JavaType> getIdToType() {
        return this.idToType;
    }

    public Map<Class, String> getTypeToId() {
        return this.typeToId;
    }

    public GraphSONTypeIdResolver addCustomType(String name, Class clasz) {
        if (Tree.class.isAssignableFrom(clasz)) {
            this.getIdToType().put(name, TypeFactory.defaultInstance().constructType(new TypeReference<Tree<? extends Element>>(){}));
        } else {
            this.getIdToType().put(name, TypeFactory.defaultInstance().constructType(clasz));
        }
        this.getTypeToId().put(clasz, name);
        return this;
    }

    @Override
    public void init(JavaType javaType) {
    }

    @Override
    public String idFromValue(Object o) {
        return this.idFromValueAndType(o, o.getClass());
    }

    @Override
    public String idFromValueAndType(Object o, Class<?> aClass) {
        if (!this.getTypeToId().containsKey(aClass)) {
            throw new IllegalArgumentException(String.format("Could not find a type identifier for the class : %s. Make sure the value to serialize has a type identifier registered for its class.", aClass));
        }
        return this.getTypeToId().get(aClass);
    }

    @Override
    public String idFromBaseType() {
        return null;
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String s) {
        return this.getIdToType().containsKey(s) ? this.getIdToType().get(s) : databindContext.constructType((Type)((Object)String.class));
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "GraphSON advanced typing system";
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }
}

