/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.javatuples.Pair;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static long secondsSince(long startNanos) {
        return TimeUtil.timeSince(startNanos, TimeUnit.SECONDS);
    }

    public static long millisSince(long startNanos) {
        return TimeUtil.timeSince(startNanos, TimeUnit.MILLISECONDS);
    }

    public static long minutesSince(long startNanos) {
        return TimeUtil.timeSince(startNanos, TimeUnit.MINUTES);
    }

    public static long timeSince(long startNanos, TimeUnit destUnit) {
        return destUnit.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
    }

    public static double clock(Runnable runnable) {
        return TimeUtil.clock(100, runnable);
    }

    public static double clock(int loops, Runnable runnable) {
        runnable.run();
        return IntStream.range(0, loops).mapToDouble(i -> {
            long t = System.nanoTime();
            runnable.run();
            return (double)(System.nanoTime() - t) * 1.0E-6;
        }).sum() / (double)loops;
    }

    public static <S> Pair<Double, S> clockWithResult(Supplier<S> supplier) {
        return TimeUtil.clockWithResult(100, supplier);
    }

    public static <S> Pair<Double, S> clockWithResult(int loops, Supplier<S> supplier) {
        S result = supplier.get();
        return Pair.with(IntStream.range(0, loops).mapToDouble(i -> {
            long t = System.nanoTime();
            supplier.get();
            return (double)(System.nanoTime() - t) * 1.0E-6;
        }).sum() / (double)loops, result);
    }
}

