/*
 * Decompiled with CFR 0.152.
 */
package com.arcadeanalytics.provider.orient3;

import com.arcadeanalytics.provider.DataSourceInfo;
import com.arcadeanalytics.provider.DataSourceMetadata;
import com.arcadeanalytics.provider.DataSourceMetadataProvider;
import com.arcadeanalytics.provider.TypeClass;
import com.arcadeanalytics.provider.TypeProperty;
import com.arcadeanalytics.provider.orient3.OrientDB3DataSourceMetadataProvider;
import com.arcadeanalytics.provider.orient3.OrientDB3UtilsKt;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001dH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/arcadeanalytics/provider/orient3/OrientDB3DataSourceMetadataProvider;", "Lcom/arcadeanalytics/provider/DataSourceMetadataProvider;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "edgeClasses", "", "", "Lcom/arcadeanalytics/provider/TypeClass;", "Lcom/arcadeanalytics/provider/EdgesClasses;", "schema", "Lcom/orientechnologies/orient/core/metadata/schema/OSchema;", "db", "Lcom/orientechnologies/orient/core/db/ODatabaseSession;", "fetchMetadata", "Lcom/arcadeanalytics/provider/DataSourceMetadata;", "dataSource", "Lcom/arcadeanalytics/provider/DataSourceInfo;", "isEdgeType", "", "it", "Lcom/orientechnologies/orient/core/metadata/schema/OClass;", "isVertexType", "mapToType", "oClass", "nodeClasses", "Lcom/arcadeanalytics/provider/NodesClasses;", "supportedDataSourceTypes", "", "arcade-connectors-orientdb3"})
public final class OrientDB3DataSourceMetadataProvider
implements DataSourceMetadataProvider {
    private final Logger log = LoggerFactory.getLogger(OrientDB3DataSourceMetadataProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public DataSourceMetadata fetchMetadata(@NotNull DataSourceInfo dataSource) {
        Intrinsics.checkParameterIsNotNull((Object)dataSource, (String)"dataSource");
        this.log.info("fetching metadata for dataSource {} ", (Object)dataSource.getId());
        Closeable closeable = OrientDB3UtilsKt.open(dataSource);
        boolean bl = false;
        Throwable throwable = null;
        try {
            OSchema schema;
            ODatabaseSession it = (ODatabaseSession)closeable;
            boolean bl2 = false;
            OMetadata oMetadata = it.getMetadata();
            Intrinsics.checkExpressionValueIsNotNull((Object)oMetadata, (String)"it.metadata");
            OSchema oSchema = schema = oMetadata.getSchema();
            Intrinsics.checkExpressionValueIsNotNull((Object)oSchema, (String)"schema");
            Map<String, TypeClass> nodesClasses = this.nodeClasses(oSchema, it);
            Map<String, TypeClass> edgeClasses2 = this.edgeClasses(schema, it);
            DataSourceMetadata dataSourceMetadata = new DataSourceMetadata(nodesClasses, edgeClasses2);
            return dataSourceMetadata;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Map<String, TypeClass> edgeClasses(OSchema schema, ODatabaseSession db) {
        Collection<OClass> collection = schema.getClasses();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"schema.classes");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<OClass, Boolean>(this){
            final /* synthetic */ OrientDB3DataSourceMetadataProvider this$0;

            public final boolean invoke(OClass it) {
                OClass oClass = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)oClass, (String)"it");
                return OrientDB3DataSourceMetadataProvider.access$isEdgeType(this.this$0, oClass);
            }
            {
                this.this$0 = orientDB3DataSourceMetadataProvider;
                super(1);
            }
        })), (Function1)((Function1)new Function1<OClass, TypeClass>(this, db){
            final /* synthetic */ OrientDB3DataSourceMetadataProvider this$0;
            final /* synthetic */ ODatabaseSession $db;

            @NotNull
            public final TypeClass invoke(OClass it) {
                OClass oClass = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)oClass, (String)"it");
                return OrientDB3DataSourceMetadataProvider.access$mapToType(this.this$0, oClass, this.$db);
            }
            {
                this.this$0 = orientDB3DataSourceMetadataProvider;
                this.$db = oDatabaseSession;
                super(1);
            }
        })), (Function1)edgeClasses.3.INSTANCE));
    }

    private final Map<String, TypeClass> nodeClasses(OSchema schema, ODatabaseSession db) {
        Collection<OClass> collection = schema.getClasses();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"schema.classes");
        return MapsKt.toMap((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)((Function1)new Function1<OClass, Boolean>(this){
            final /* synthetic */ OrientDB3DataSourceMetadataProvider this$0;

            public final boolean invoke(OClass it) {
                OClass oClass = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)oClass, (String)"it");
                return OrientDB3DataSourceMetadataProvider.access$isVertexType(this.this$0, oClass);
            }
            {
                this.this$0 = orientDB3DataSourceMetadataProvider;
                super(1);
            }
        })), (Function1)((Function1)new Function1<OClass, TypeClass>(this, db){
            final /* synthetic */ OrientDB3DataSourceMetadataProvider this$0;
            final /* synthetic */ ODatabaseSession $db;

            @NotNull
            public final TypeClass invoke(OClass it) {
                OClass oClass = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)oClass, (String)"it");
                return OrientDB3DataSourceMetadataProvider.access$mapToType(this.this$0, oClass, this.$db);
            }
            {
                this.this$0 = orientDB3DataSourceMetadataProvider;
                this.$db = oDatabaseSession;
                super(1);
            }
        })), (Function1)nodeClasses.3.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final TypeClass mapToType(OClass oClass, ODatabaseSession db) {
        void $this$mapTo$iv$iv;
        Collection<OProperty> collection = oClass.properties();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"oClass.properties()");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void prop;
            OProperty oProperty = (OProperty)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = prop;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"prop");
            String string = v1.getName();
            String string2 = prop.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"prop.name");
            Pair pair = TuplesKt.to((Object)string, (Object)new TypeProperty(string2, prop.getType().name()));
            collection2.add(pair);
        }
        Map props2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String string = oClass.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"oClass.name");
        return new TypeClass(string, db.countClass(oClass.getName(), true), props2);
    }

    private final boolean isEdgeType(OClass it) {
        return it.isEdgeType() && Intrinsics.areEqual((Object)it.getName(), (Object)"E") ^ true;
    }

    private final boolean isVertexType(OClass it) {
        return it.isVertexType() && Intrinsics.areEqual((Object)it.getName(), (Object)"V") ^ true;
    }

    @NotNull
    public Set<String> supportedDataSourceTypes() {
        return SetsKt.setOf((Object)"ORIENTDB3");
    }

    public static final /* synthetic */ boolean access$isEdgeType(OrientDB3DataSourceMetadataProvider $this, OClass it) {
        return $this.isEdgeType(it);
    }

    public static final /* synthetic */ TypeClass access$mapToType(OrientDB3DataSourceMetadataProvider $this, OClass oClass, ODatabaseSession db) {
        return $this.mapToType(oClass, db);
    }

    public static final /* synthetic */ boolean access$isVertexType(OrientDB3DataSourceMetadataProvider $this, OClass it) {
        return $this.isVertexType(it);
    }
}

