/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AbstractXmlConfigHelper;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.XmlElements;
import com.hazelcast.config.replacer.PropertyReplacer;
import com.hazelcast.config.replacer.spi.ConfigReplacer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.util.StringUtil;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractConfigBuilder
extends AbstractXmlConfigHelper {
    private static final ILogger LOGGER = Logger.getLogger(AbstractConfigBuilder.class);
    private final Set<String> currentlyImportedFiles = new HashSet<String>();
    private final XPath xpath;

    public AbstractConfigBuilder() {
        XPathFactory fac = XPathFactory.newInstance();
        this.xpath = fac.newXPath();
        this.xpath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return "hz".equals(prefix) ? AbstractConfigBuilder.this.xmlns : null;
            }

            @Override
            public String getPrefix(String namespaceURI) {
                return null;
            }

            @Override
            public Iterator getPrefixes(String namespaceURI) {
                return null;
            }
        });
    }

    protected void process(Node root) throws Exception {
        this.traverseChildrenAndReplaceVariables(root);
        this.replaceImportElementsWithActualFileContents(root);
    }

    private void replaceImportElementsWithActualFileContents(Node root) throws Exception {
        Document document = root.getOwnerDocument();
        NodeList misplacedImports = (NodeList)this.xpath.evaluate(String.format("//hz:%s/parent::*[not(self::hz:%s)]", XmlElements.IMPORT.name, this.getXmlType().name), document, XPathConstants.NODESET);
        if (misplacedImports.getLength() > 0) {
            throw new InvalidConfigurationException("<import> element can appear only in the top level of the XML");
        }
        NodeList importTags = (NodeList)this.xpath.evaluate(String.format("/hz:%s/hz:%s", this.getXmlType().name, XmlElements.IMPORT.name), document, XPathConstants.NODESET);
        for (Node node : AbstractConfigBuilder.asElementIterable(importTags)) {
            this.loadAndReplaceImportElement(root, node);
        }
    }

    private void loadAndReplaceImportElement(Node root, Node node) throws Exception {
        NamedNodeMap attributes = node.getAttributes();
        Node resourceAttribute = attributes.getNamedItem("resource");
        String resource = resourceAttribute.getTextContent();
        URL url = ConfigLoader.locateConfig(resource);
        if (url == null) {
            throw new InvalidConfigurationException("Failed to load resource: " + resource);
        }
        if (!this.currentlyImportedFiles.add(url.getPath())) {
            throw new InvalidConfigurationException("Cyclic loading of resource '" + url.getPath() + "' detected!");
        }
        Document doc = this.parse(url.openStream());
        Element importedRoot = doc.getDocumentElement();
        this.traverseChildrenAndReplaceVariables(importedRoot);
        this.replaceImportElementsWithActualFileContents(importedRoot);
        for (Node fromImportedDoc : AbstractConfigBuilder.childElements(importedRoot)) {
            Node importedNode = root.getOwnerDocument().importNode(fromImportedDoc, true);
            root.insertBefore(importedNode, node);
        }
        root.removeChild(node);
    }

    protected abstract Document parse(InputStream var1) throws Exception;

    protected abstract Properties getProperties();

    @Override
    protected abstract ConfigType getXmlType();

    private void traverseChildrenAndReplaceVariables(Node root) throws Exception {
        boolean failFast = false;
        ArrayList<ConfigReplacer> replacers = new ArrayList<ConfigReplacer>();
        PropertyReplacer propertyReplacer = new PropertyReplacer();
        propertyReplacer.init(this.getProperties());
        replacers.add(propertyReplacer);
        Node node = (Node)this.xpath.evaluate(String.format("/hz:%s/hz:%s", this.getXmlType().name, XmlElements.CONFIG_REPLACERS.name), root, XPathConstants.NODE);
        if (node != null) {
            String failFastAttr = this.getAttribute(node, "fail-if-value-missing");
            failFast = StringUtil.isNullOrEmpty(failFastAttr) ? true : Boolean.parseBoolean(failFastAttr);
            for (Node n : AbstractConfigBuilder.childElements(node)) {
                String value = AbstractConfigBuilder.cleanNodeName(n);
                if (!"replacer".equals(value)) continue;
                replacers.add(this.createReplacer(n));
            }
        }
        for (ConfigReplacer replacer : replacers) {
            this.traverseChildrenAndReplaceVariables(root, replacer, failFast);
        }
    }

    private ConfigReplacer createReplacer(Node node) throws Exception {
        String replacerClass = this.getAttribute(node, "class-name");
        Properties properties = new Properties();
        for (Node n : AbstractConfigBuilder.childElements(node)) {
            String value = AbstractConfigBuilder.cleanNodeName(n);
            if (!"properties".equals(value)) continue;
            this.fillProperties(n, properties);
        }
        ConfigReplacer replacer = (ConfigReplacer)Class.forName(replacerClass).newInstance();
        replacer.init(properties);
        return replacer;
    }

    private void traverseChildrenAndReplaceVariables(Node root, ConfigReplacer replacer, boolean failFast) {
        NamedNodeMap attributes = root.getAttributes();
        if (attributes != null) {
            for (int k = 0; k < attributes.getLength(); ++k) {
                Node attribute = attributes.item(k);
                this.replaceVariables(attribute, replacer, failFast);
            }
        }
        if (root.getNodeValue() != null) {
            this.replaceVariables(root, replacer, failFast);
        }
        NodeList childNodes = root.getChildNodes();
        for (int k = 0; k < childNodes.getLength(); ++k) {
            Node child = childNodes.item(k);
            this.traverseChildrenAndReplaceVariables(child, replacer, failFast);
        }
    }

    private void replaceVariables(Node node, ConfigReplacer replacer, boolean failFast) {
        String value = node.getNodeValue();
        StringBuilder sb = new StringBuilder(value);
        String replacerPrefix = "$" + replacer.getPrefix() + "{";
        int endIndex = -1;
        int startIndex = sb.indexOf(replacerPrefix);
        while (startIndex > -1) {
            endIndex = sb.indexOf("}", startIndex);
            if (endIndex == -1) {
                LOGGER.warning("Bad variable syntax. Could not find a closing curly bracket '}' for prefix " + replacerPrefix + " on node: " + node.getLocalName());
                break;
            }
            String variable = sb.substring(startIndex + replacerPrefix.length(), endIndex);
            String variableReplacement = replacer.getReplacement(variable);
            if (variableReplacement != null) {
                sb.replace(startIndex, endIndex + 1, variableReplacement);
                endIndex = startIndex + variableReplacement.length();
            } else {
                this.handleMissingVariable(sb.substring(startIndex, endIndex + 1), node.getLocalName(), failFast);
            }
            startIndex = sb.indexOf(replacerPrefix, endIndex);
        }
        node.setNodeValue(sb.toString());
    }

    private void handleMissingVariable(String variable, String nodeName, boolean failFast) throws ConfigurationException {
        String message = String.format("Could not find a replacement for '%s' on node '%s'", variable, nodeName);
        if (failFast) {
            throw new ConfigurationException(message);
        }
        LOGGER.warning(message);
    }

    protected static enum ConfigType {
        SERVER("hazelcast"),
        CLIENT("hazelcast-client"),
        JET("hazelcast-jet");

        final String name;

        private ConfigType(String name) {
            this.name = name;
        }
    }
}

