/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.StampedLock;

public class ScalableRWLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -7552055681918630764L;
    private static final int SRWL_STATE_NOT_WRITING = 0;
    private static final int SRWL_STATE_WRITING = 1;
    private static final int SRWL_STATE_NOT_READING = 0;
    private static final int SRWL_STATE_READING = 1;
    private static final AtomicInteger[] dummyArray = new AtomicInteger[0];
    private final transient ConcurrentLinkedQueue<AtomicInteger> readersStateList = new ConcurrentLinkedQueue();
    private final transient StampedLock stampedLock = new StampedLock();
    private final transient ThreadLocal<ReadersEntry> entry = new ThreadLocal();
    private final transient AtomicReference<AtomicInteger[]> readersStateArrayRef = new AtomicReference<Object>(null);
    private final InnerReadLock readerLock = new InnerReadLock();
    private final InnerWriteLock writerLock = new InnerWriteLock();

    @Override
    public Lock readLock() {
        return this.readerLock;
    }

    @Override
    public Lock writeLock() {
        return this.writerLock;
    }

    protected void removeState(AtomicInteger state) {
        this.readersStateList.remove(state);
        this.readersStateArrayRef.set(null);
        state.set(0);
    }

    private ReadersEntry addState() {
        AtomicInteger state = new AtomicInteger(0);
        ReadersEntry newEntry = new ReadersEntry(state);
        this.entry.set(newEntry);
        this.readersStateList.add(state);
        this.readersStateArrayRef.set(null);
        return newEntry;
    }

    public void sharedLock() {
        ReadersEntry localEntry = this.entry.get();
        if (localEntry == null) {
            localEntry = this.addState();
        }
        AtomicInteger currentReadersState = localEntry.state;
        block0: while (true) {
            currentReadersState.set(1);
            if (!this.stampedLock.isWriteLocked()) {
                return;
            }
            currentReadersState.set(0);
            while (true) {
                if (!this.stampedLock.isWriteLocked()) continue block0;
                Thread.yield();
            }
            break;
        }
    }

    public void sharedUnlock() {
        ReadersEntry localEntry = this.entry.get();
        if (localEntry == null) {
            throw new IllegalMonitorStateException();
        }
        localEntry.state.set(0);
    }

    public void exclusiveLock() {
        this.stampedLock.writeLock();
        AtomicInteger[] localReadersStateArray = this.readersStateArrayRef.get();
        if (localReadersStateArray == null) {
            this.readersStateArrayRef.set(dummyArray);
            localReadersStateArray = this.readersStateList.toArray(new AtomicInteger[this.readersStateList.size()]);
            this.readersStateArrayRef.compareAndSet(dummyArray, localReadersStateArray);
        }
        for (AtomicInteger readerState : localReadersStateArray) {
            while (readerState != null && readerState.get() == 1) {
                Thread.yield();
            }
        }
    }

    public void exclusiveUnlock() {
        if (!this.stampedLock.isWriteLocked()) {
            throw new IllegalMonitorStateException();
        }
        this.stampedLock.asWriteLock().unlock();
    }

    public boolean sharedTryLock() {
        ReadersEntry localEntry = this.entry.get();
        if (localEntry == null) {
            localEntry = this.addState();
        }
        AtomicInteger currentReadersState = localEntry.state;
        currentReadersState.set(1);
        if (!this.stampedLock.isWriteLocked()) {
            return true;
        }
        currentReadersState.set(0);
        return false;
    }

    public boolean sharedTryLockNanos(long nanosTimeout) {
        long lastTime = System.nanoTime();
        ReadersEntry localEntry = this.entry.get();
        if (localEntry == null) {
            localEntry = this.addState();
        }
        AtomicInteger currentReadersState = localEntry.state;
        while (true) {
            currentReadersState.set(1);
            if (!this.stampedLock.isWriteLocked()) {
                return true;
            }
            currentReadersState.set(0);
            if (nanosTimeout <= 0L) {
                return false;
            }
            if (System.nanoTime() - lastTime >= nanosTimeout) break;
            Thread.yield();
        }
        return false;
    }

    public boolean exclusiveTryLock() {
        if (this.stampedLock.tryWriteLock() == 0L) {
            return false;
        }
        AtomicInteger[] localReadersStateArray = this.readersStateArrayRef.get();
        if (localReadersStateArray == null) {
            this.readersStateArrayRef.set(dummyArray);
            localReadersStateArray = this.readersStateList.toArray(new AtomicInteger[this.readersStateList.size()]);
            this.readersStateArrayRef.compareAndSet(dummyArray, localReadersStateArray);
        }
        for (AtomicInteger readerState : localReadersStateArray) {
            if (readerState == null || readerState.get() != 1) continue;
            this.stampedLock.asWriteLock().unlock();
            return false;
        }
        return true;
    }

    public boolean exclusiveTryLockNanos(long nanosTimeout) throws InterruptedException {
        long lastTime = System.nanoTime();
        if (this.stampedLock.tryWriteLock(nanosTimeout, TimeUnit.NANOSECONDS) == 0L) {
            return false;
        }
        AtomicInteger[] localReadersStateArray = this.readersStateArrayRef.get();
        if (localReadersStateArray == null) {
            this.readersStateArrayRef.set(dummyArray);
            localReadersStateArray = this.readersStateList.toArray(new AtomicInteger[this.readersStateList.size()]);
            this.readersStateArrayRef.compareAndSet(dummyArray, localReadersStateArray);
        }
        for (AtomicInteger readerState : localReadersStateArray) {
            while (readerState != null && readerState.get() == 1) {
                if (System.nanoTime() - lastTime < nanosTimeout) {
                    Thread.yield();
                    continue;
                }
                this.stampedLock.asWriteLock().unlock();
                return false;
            }
        }
        return true;
    }

    final class InnerWriteLock
    implements Lock {
        InnerWriteLock() {
        }

        @Override
        public void lock() {
            ScalableRWLock.this.exclusiveLock();
        }

        @Override
        public void unlock() {
            ScalableRWLock.this.exclusiveUnlock();
        }

        @Override
        public boolean tryLock() {
            return ScalableRWLock.this.exclusiveTryLock();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            return ScalableRWLock.this.exclusiveTryLockNanos(unit.toNanos(timeout));
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    final class InnerReadLock
    implements Lock {
        InnerReadLock() {
        }

        @Override
        public void lock() {
            ScalableRWLock.this.sharedLock();
        }

        @Override
        public void unlock() {
            ScalableRWLock.this.sharedUnlock();
        }

        @Override
        public boolean tryLock() {
            return ScalableRWLock.this.sharedTryLock();
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            return ScalableRWLock.this.sharedTryLockNanos(unit.toNanos(timeout));
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }

    final class ReadersEntry {
        public final AtomicInteger state;

        public ReadersEntry(AtomicInteger state) {
            this.state = state;
        }

        protected void finalize() throws Throwable {
            ScalableRWLock.this.removeState(this.state);
            super.finalize();
        }
    }
}

