/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class OResourcePool<K, V> {
    protected final Semaphore sem;
    protected final Queue<V> resources = new ConcurrentLinkedQueue<V>();
    protected final Queue<V> resourcesOut = new ConcurrentLinkedQueue<V>();
    protected final Collection<V> unmodifiableresources;
    private final int maxResources;
    protected OResourcePoolListener<K, V> listener;
    protected final AtomicInteger created = new AtomicInteger();

    public OResourcePool(int max, OResourcePoolListener<K, V> listener) {
        this(0, max, listener);
    }

    public OResourcePool(int min, int max, OResourcePoolListener<K, V> listener) {
        this.maxResources = max;
        if (this.maxResources < 1) {
            throw new IllegalArgumentException("iMaxResource must be major than 0");
        }
        this.listener = listener;
        this.sem = new Semaphore(this.maxResources, true);
        this.unmodifiableresources = Collections.unmodifiableCollection(this.resources);
        for (int i = 0; i < min; ++i) {
            V res = listener.createNewResource(null, null);
            this.created.incrementAndGet();
            this.resources.add(res);
        }
    }

    public V getResource(K key, long maxWaitMillis, Object ... additionalArgs) throws OLockException {
        V res;
        try {
            if (!this.sem.tryAcquire(maxWaitMillis, TimeUnit.MILLISECONDS)) {
                throw new OLockException("No more resources available in pool (max=" + this.maxResources + "). Requested resource: " + key);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OException.wrapException(new OInterruptedException("Acquiring of resources was interrupted"), e);
        }
        do {
            if ((res = this.resources.poll()) == null) continue;
            if (this.listener.reuseResource(key, additionalArgs, res)) break;
            res = null;
        } while (!this.resources.isEmpty());
        try {
            if (res == null) {
                res = this.listener.createNewResource(key, additionalArgs);
                this.created.incrementAndGet();
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "pool:'%s' created new resource '%s', new resource count '%d'", this, res, this.created.get());
                }
            }
            this.resourcesOut.add(res);
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "pool:'%s' acquired resource '%s' available %d out %d ", this, res, this.sem.availablePermits(), this.resourcesOut.size());
            }
            return res;
        }
        catch (RuntimeException e) {
            this.sem.release();
            throw e;
        }
        catch (Exception e) {
            this.sem.release();
            throw OException.wrapException(new OLockException("Error on creation of the new resource in the pool"), e);
        }
    }

    public int getMaxResources() {
        return this.maxResources;
    }

    public int getAvailableResources() {
        return this.sem.availablePermits();
    }

    public int getInPoolResources() {
        return this.resources.size();
    }

    public boolean returnResource(V res) {
        if (this.resourcesOut.remove(res)) {
            this.resources.add(res);
            this.sem.release();
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "pool:'%s' returned resource '%s' available %d out %d", this, res, this.sem.availablePermits(), this.resourcesOut.size());
            }
        }
        return true;
    }

    public Collection<V> getResources() {
        return this.unmodifiableresources;
    }

    public void close() {
        this.sem.drainPermits();
    }

    public Collection<V> getAllResources() {
        ArrayList<V> all = new ArrayList<V>(this.resources);
        all.addAll(this.resourcesOut);
        return all;
    }

    public void remove(V res) {
        if (this.resourcesOut.remove(res)) {
            this.resources.remove(res);
            this.sem.release();
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "pool:'%s' removed resource '%s' available %d out %d", this, res, this.sem.availablePermits(), this.resourcesOut.size());
            }
        }
    }

    public int getCreatedInstances() {
        return this.created.get();
    }
}

