/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class OPointer {
    private final Pointer pointer;
    private final int size;
    private final ByteBuffer byteBuffer;
    private int hash = 0;

    OPointer(Pointer pointer, int size) {
        this.pointer = pointer;
        this.size = size;
        this.byteBuffer = pointer.getByteBuffer(0L, size);
    }

    public void clear() {
        this.pointer.setMemory(0L, this.size, (byte)0);
    }

    public ByteBuffer getNativeByteBuffer() {
        return this.byteBuffer;
    }

    Pointer getNativePointer() {
        return this.pointer;
    }

    int getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OPointer other = (OPointer)o;
        return this.size == other.size && Objects.equals(this.pointer, other.pointer);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = Objects.hash(this.pointer, this.size);
        return this.hash;
    }
}

