/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.orientechnologies.common.profiler.OAbstractProfiler;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.profiler.OProfilerEntry;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class OProfilerStub
extends OAbstractProfiler {
    protected ConcurrentMap<String, Long> counters;
    private ConcurrentLinkedHashMap<String, AtomicInteger> tips;
    private ConcurrentLinkedHashMap<String, Long> tipsTimestamp;

    public OProfilerStub() {
    }

    public OProfilerStub(boolean registerListener) {
        super(registerListener);
    }

    public OProfilerStub(OAbstractProfiler profiler) {
        super(profiler);
    }

    @Override
    public void startup() {
        this.counters = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        this.tips = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        this.tipsTimestamp = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        super.startup();
    }

    @Override
    public void shutdown() {
        if (this.counters != null) {
            this.counters.clear();
        }
        if (this.tips != null) {
            this.tips.clear();
        }
        if (this.tipsTimestamp != null) {
            this.tipsTimestamp.clear();
        }
        super.shutdown();
    }

    @Override
    protected void setTip(String iMessage, AtomicInteger counter) {
        if (!this.isRecording()) {
            return;
        }
        this.tips.put(iMessage, counter);
        this.tipsTimestamp.put(iMessage, System.currentTimeMillis());
    }

    @Override
    protected AtomicInteger getTip(String iMessage) {
        if (!this.isRecording()) {
            return null;
        }
        if (iMessage == null) {
            return null;
        }
        return this.tips.get(iMessage);
    }

    @Override
    public boolean isEnterpriseEdition() {
        return false;
    }

    @Override
    public void configure(String iConfiguration) {
        if (iConfiguration == null || iConfiguration.length() == 0) {
            return;
        }
        if (this.isRecording()) {
            this.stopRecording();
        }
        this.startRecording();
    }

    @Override
    public boolean startRecording() {
        this.counters = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        this.tips = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        this.tipsTimestamp = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(OGlobalConfiguration.PROFILER_MAXVALUES.getValueAsInteger()).build();
        if (super.startRecording()) {
            this.counters.clear();
            return true;
        }
        return false;
    }

    @Override
    public boolean stopRecording() {
        if (super.stopRecording()) {
            this.counters.clear();
            return true;
        }
        return false;
    }

    @Override
    public String dump() {
        if (this.recordingFrom < 0L) {
            return "<no recording>";
        }
        StringBuilder buffer = new StringBuilder(super.dump());
        if (this.tips.size() == 0) {
            return "";
        }
        buffer.append("TIPS:");
        buffer.append(String.format("\n%100s +------------+", ""));
        buffer.append(String.format("\n%100s | Value      |", "Name"));
        buffer.append(String.format("\n%100s +------------+", ""));
        ArrayList<String> names = new ArrayList<String>(this.tips.keySet());
        Collections.sort(names);
        for (String n : names) {
            AtomicInteger v = this.tips.get(n);
            buffer.append(String.format("\n%-100s | %10d |", n, v.intValue()));
        }
        buffer.append(String.format("\n%100s +------------+", ""));
        return buffer.toString();
    }

    @Override
    public void updateCounter(String statName, String description, long plus, String metadata) {
        Long newValue;
        Long oldValue;
        if (statName == null || !this.isRecording()) {
            return;
        }
        do {
            if ((oldValue = (Long)this.counters.get(statName)) != null) continue;
            this.counters.putIfAbsent(statName, 0L);
            oldValue = (Long)this.counters.get(statName);
        } while (!this.counters.replace(statName, oldValue, newValue = Long.valueOf(oldValue + plus)));
    }

    @Override
    public long getCounter(String statName) {
        if (statName == null || !this.isRecording()) {
            return -1L;
        }
        Long stat = (Long)this.counters.get(statName);
        if (stat == null) {
            return -1L;
        }
        return stat;
    }

    @Override
    public String dumpCounters() {
        return null;
    }

    @Override
    public OProfilerEntry getChrono(String string) {
        return null;
    }

    @Override
    public long startChrono() {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime) {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionary) {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionary, String payload) {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionary, String payload, String user) {
        return 0L;
    }

    @Override
    public String dumpChronos() {
        return null;
    }

    @Override
    public String[] getCountersAsString() {
        ArrayList keys2 = new ArrayList(this.counters.keySet());
        String[] result = new String[keys2.size()];
        return keys2.toArray(result);
    }

    @Override
    public List<String> getChronos() {
        return Collections.emptyList();
    }

    @Override
    public Date getLastReset() {
        return null;
    }

    @Override
    public String metadataToJSON() {
        return null;
    }

    @Override
    public Object getHookValue(String iName) {
        return null;
    }

    @Override
    public String toJSON(String command, String iPar1) {
        return null;
    }

    @Override
    public void resetRealtime(String iText) {
    }

    @Override
    public String getStatsAsJson() {
        return null;
    }

    @Override
    protected void updateMetadata(String iName, String iDescription, OProfiler.METRIC_TYPE iType) {
        if (iDescription != null && this.dictionary.putIfAbsent(iName, iDescription) == null) {
            this.types.put(iName, iType);
        }
    }
}

