/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote.message;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.OFetchPlanResults;
import com.orientechnologies.orient.client.remote.OStorageRemoteSession;
import com.orientechnologies.orient.client.remote.SimpleValueFetchPlanCommandListener;
import com.orientechnologies.orient.client.remote.message.OMessageHelper;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.sql.query.OBasicLegacyResultSet;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataInput;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OCommandResponse
implements OBinaryResponse {
    private boolean asynch;
    private OCommandResultListener listener;
    private ODatabaseDocumentInternal database;
    private boolean live;
    private Object result;
    private boolean isRecordResultSet;
    private OCommandRequestText command;
    private Map<Object, Object> params;

    public OCommandResponse(Object result, SimpleValueFetchPlanCommandListener listener, boolean isRecordResultSet, boolean async, ODatabaseDocumentInternal database, OCommandRequestText command, Map<Object, Object> params) {
        this.result = result;
        this.listener = listener;
        this.isRecordResultSet = isRecordResultSet;
        this.asynch = async;
        this.database = database;
        this.command = command;
        this.params = params;
    }

    public OCommandResponse(boolean asynch, OCommandResultListener listener, ODatabaseDocumentInternal database, boolean live) {
        this.asynch = asynch;
        this.listener = listener;
        this.database = database;
        this.live = live;
    }

    @Override
    public void write(OChannelDataOutput channel, int protocolVersion, ORecordSerializer serializer) throws IOException {
        if (this.asynch) {
            this.result = this.params == null ? this.database.command(this.command).execute(new Object[0]) : this.database.command(this.command).execute(this.params);
            channel.writeByte((byte)0);
        } else {
            this.serializeValue(channel, (SimpleValueFetchPlanCommandListener)this.listener, this.result, false, this.isRecordResultSet, protocolVersion, serializer);
            if (this.listener instanceof OFetchPlanResults) {
                for (ORecord rec : ((OFetchPlanResults)((Object)this.listener)).getFetchedRecordsToSend()) {
                    channel.writeByte((byte)2);
                    OMessageHelper.writeIdentifiable(channel, rec, serializer);
                }
                channel.writeByte((byte)0);
            }
        }
    }

    public void serializeValue(OChannelDataOutput channel, SimpleValueFetchPlanCommandListener listener, Object result, boolean load, boolean isRecordResultSet, int protocolVersion, ORecordSerializer recordSerializer) throws IOException {
        if (result == null) {
            channel.writeByte((byte)110);
        } else if (result instanceof OIdentifiable) {
            channel.writeByte((byte)114);
            if (load && result instanceof ORecordId) {
                result = ((ORecordId)result).getRecord();
            }
            if (listener != null) {
                listener.result(result);
            }
            OMessageHelper.writeIdentifiable(channel, (OIdentifiable)result, recordSerializer);
        } else if (result instanceof ODocumentWrapper) {
            channel.writeByte((byte)114);
            ODocument doc = ((ODocumentWrapper)result).getDocument();
            if (listener != null) {
                listener.result(doc);
            }
            OMessageHelper.writeIdentifiable(channel, doc, recordSerializer);
        } else if (!isRecordResultSet) {
            this.writeSimpleValue(channel, listener, result, protocolVersion, recordSerializer);
        } else if (OMultiValue.isMultiValue(result)) {
            byte collectionType = result instanceof Set ? (byte)115 : 108;
            channel.writeByte(collectionType);
            channel.writeInt(OMultiValue.getSize(result));
            for (Object o : OMultiValue.getMultiValueIterable(result, false)) {
                try {
                    if (load && o instanceof ORecordId) {
                        o = ((ORecordId)o).getRecord();
                    }
                    if (listener != null) {
                        listener.result(o);
                    }
                    OMessageHelper.writeIdentifiable(channel, (OIdentifiable)o, recordSerializer);
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    OMessageHelper.writeIdentifiable(channel, null, recordSerializer);
                }
            }
        } else if (OMultiValue.isIterable(result)) {
            if (protocolVersion >= 32) {
                channel.writeByte((byte)105);
                for (Object o : OMultiValue.getMultiValueIterable(result)) {
                    try {
                        if (load && o instanceof ORecordId) {
                            o = ((ORecordId)o).getRecord();
                        }
                        if (listener != null) {
                            listener.result(o);
                        }
                        channel.writeByte((byte)1);
                        OMessageHelper.writeIdentifiable(channel, (OIdentifiable)o, recordSerializer);
                    }
                    catch (Exception e) {
                        OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    }
                }
                channel.writeByte((byte)0);
            } else {
                byte collectionType = result instanceof Set ? (byte)115 : 108;
                channel.writeByte(collectionType);
                channel.writeInt(OMultiValue.getSize(result));
                for (Object o : OMultiValue.getMultiValueIterable(result)) {
                    try {
                        if (load && o instanceof ORecordId) {
                            o = ((ORecordId)o).getRecord();
                        }
                        if (listener != null) {
                            listener.result(o);
                        }
                        OMessageHelper.writeIdentifiable(channel, (OIdentifiable)o, recordSerializer);
                    }
                    catch (Exception e) {
                        OLogManager.instance().warn((Object)this, "Cannot serialize record: " + o, new Object[0]);
                    }
                }
            }
        } else {
            this.writeSimpleValue(channel, listener, result, protocolVersion, recordSerializer);
        }
    }

    private void writeSimpleValue(OChannelDataOutput channel, SimpleValueFetchPlanCommandListener listener, Object result, int protocolVersion, ORecordSerializer recordSerializer) throws IOException {
        if (protocolVersion >= 35) {
            channel.writeByte((byte)119);
            ODocument document = new ODocument();
            document.field("result", result);
            OMessageHelper.writeIdentifiable(channel, document, recordSerializer);
            if (listener != null) {
                listener.linkdedBySimpleValue(document);
            }
        } else {
            channel.writeByte((byte)97);
            StringBuilder value = new StringBuilder(64);
            if (listener != null) {
                ODocument document = new ODocument();
                document.field("result", result);
                listener.linkdedBySimpleValue(document);
            }
            ORecordSerializerStringAbstract.fieldTypeToString(value, OType.getTypeByClass(result.getClass()), result);
            channel.writeString(value.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(OChannelDataInput network, OStorageRemoteSession session) throws IOException {
        ORecordSerializerNetworkV37 serializer = ORecordSerializerNetworkV37.INSTANCE;
        try {
            ArrayList<ORecord> temporaryResults = new ArrayList<ORecord>();
            boolean addNextRecord = true;
            if (this.asynch) {
                byte status;
                while ((status = network.readByte()) > 0) {
                    ORecord record = (ORecord)OMessageHelper.readIdentifiable(network, serializer);
                    if (record == null) continue;
                    switch (status) {
                        case 1: {
                            if (!addNextRecord) break;
                            addNextRecord = this.listener.result(record);
                            this.database.getLocalCache().updateRecord(record);
                            break;
                        }
                        case 2: {
                            if (record.getIdentity().getClusterId() == -2) {
                                temporaryResults.add(record);
                            }
                            this.database.getLocalCache().updateRecord(record);
                        }
                    }
                }
            } else {
                this.result = this.readSynchResult(network, this.database, temporaryResults);
                if (this.live) {
                    ODocument doc = (ODocument)((List)this.result).get(0);
                    Integer token = (Integer)doc.field("token");
                    Boolean unsubscribe = (Boolean)doc.field("unsubscribe");
                    if (token == null) {
                        throw new OStorageException("Cannot execute live query, returned null token");
                    }
                }
            }
            if (!temporaryResults.isEmpty() && this.result instanceof OBasicLegacyResultSet) {
                ((OBasicLegacyResultSet)this.result).setTemporaryRecordCache(temporaryResults);
            }
        }
        finally {
            session.commandExecuting = false;
            if (this.listener != null && !this.live) {
                this.listener.end();
            }
        }
    }

    protected Object readSynchResult(OChannelDataInput network, ODatabaseDocument database, List<ORecord> temporaryResults) throws IOException {
        byte status;
        Collection<Object> result;
        ORecordSerializerNetworkV37 serializer = ORecordSerializerNetworkV37.INSTANCE;
        byte type = network.readByte();
        switch (type) {
            case 110: {
                result = null;
                break;
            }
            case 114: {
                result = OMessageHelper.readIdentifiable(network, serializer);
                if (!(result instanceof ORecord)) break;
                database.getLocalCache().updateRecord((ORecord)((Object)result));
                break;
            }
            case 108: 
            case 115: {
                int tot = network.readInt();
                Collection<Object> coll = type == 115 ? new HashSet(tot) : new OBasicLegacyResultSet(tot);
                for (int i = 0; i < tot; ++i) {
                    OIdentifiable resultItem = OMessageHelper.readIdentifiable(network, serializer);
                    if (resultItem instanceof ORecord) {
                        database.getLocalCache().updateRecord((ORecord)resultItem);
                    }
                    coll.add(resultItem);
                }
                result = coll;
                break;
            }
            case 105: {
                OIdentifiable record;
                byte status2;
                Collection<Object> coll = new OBasicLegacyResultSet();
                while ((status2 = network.readByte()) > 0) {
                    record = OMessageHelper.readIdentifiable(network, serializer);
                    if (record == null || status2 != 1) continue;
                    if (record instanceof ORecord) {
                        database.getLocalCache().updateRecord((ORecord)record);
                    }
                    coll.add(record);
                }
                result = coll;
                break;
            }
            case 119: {
                OIdentifiable record = OMessageHelper.readIdentifiable(network, serializer);
                result = ((ODocument)record).field("result");
                break;
            }
            default: {
                OLogManager.instance().warn((Object)this, "Received unexpected result from query: %d", type);
                result = null;
            }
        }
        while ((status = network.readByte()) > 0) {
            ORecord record = (ORecord)OMessageHelper.readIdentifiable(network, serializer);
            if (record == null || status != 2) continue;
            database.getLocalCache().updateRecord(record);
            if (record.getIdentity().getClusterId() != -2) continue;
            temporaryResults.add(record);
        }
        return result;
    }

    public Object getResult() {
        return this.result;
    }
}

