/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;

public interface ODatabaseDocument
extends ODatabase<ORecord> {
    public static final String TYPE = "document";

    public ORecordIteratorClass<ODocument> browseClass(String var1);

    public ORecordIteratorClass<ODocument> browseClass(String var1, boolean var2);

    public <RET> RET newInstance(String var1);

    public OBlob newBlob(byte[] var1);

    public OBlob newBlob();

    public long countClass(String var1);

    public long countClass(String var1, boolean var2);

    @Override
    public void freeze();

    @Override
    public void release();

    @Override
    public void freeze(boolean var1);

    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String var1);

    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String var1, long var2, long var4, boolean var6);

    @Deprecated
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String var1, Class<REC> var2);

    @Deprecated
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String var1, Class<REC> var2, long var3, long var5);

    @Deprecated
    public <REC extends ORecord> ORecordIteratorCluster<REC> browseCluster(String var1, Class<REC> var2, long var3, long var5, boolean var7);

    public <RET extends ORecord> RET getRecord(OIdentifiable var1);

    public byte getRecordType();

    public boolean isRetainRecords();

    public ODatabaseDocument setRetainRecords(boolean var1);

    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric var1, String var2, int var3);

    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric var1, int var2, Object var3);

    public <DB extends ODatabaseDocument> DB checkSecurity(ORule.ResourceGeneric var1, int var2, Object ... var3);

    public boolean isValidationEnabled();

    public <DB extends ODatabaseDocument> DB setValidationEnabled(boolean var1);

    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String var1, int var2);

    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String var1, int var2, Object var3);

    @Deprecated
    public <DB extends ODatabaseDocument> DB checkSecurity(String var1, int var2, Object ... var3);

    public boolean isPooled();

    @Override
    public int addBlobCluster(String var1, Object ... var2);

    public OElement newElement();

    public OElement newElement(String var1);

    default public OEdge newEdge(OVertex from, OVertex to) {
        return this.newEdge(from, to, "E");
    }

    public OEdge newEdge(OVertex var1, OVertex var2, OClass var3);

    public OEdge newEdge(OVertex var1, OVertex var2, String var3);

    default public OVertex newVertex() {
        return this.newVertex("V");
    }

    public OVertex newVertex(OClass var1);

    public OVertex newVertex(String var1);

    default public OClass createVertexClass(String className) throws OSchemaException {
        return this.createClass(className, "V");
    }

    default public OClass createEdgeClass(String className) {
        return this.createClass(className, "E");
    }

    default public OClass createClassIfNotExist(String className, String ... superclasses) throws OSchemaException {
        OSchema schema = this.getMetadata().getSchema();
        schema.reload();
        OClass result = schema.getClass(className);
        if (result == null) {
            result = this.createClass(className, superclasses);
        }
        return result;
    }
}

