/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.comparator.OCaseInsentiveComparator;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;

public class OPropertyRemote
extends OPropertyImpl {
    OPropertyRemote(OClassImpl owner) {
        super(owner);
    }

    OPropertyRemote(OClassImpl owner, ODocument document) {
        super(owner, document);
    }

    public OPropertyRemote(OClassImpl oClassImpl, OGlobalProperty global) {
        super(oClassImpl, global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setType(OType type) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        ODatabaseDocumentInternal database = this.getDatabase();
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter property %s type %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(type.toString()));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setName(String name) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s name %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(name));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setDescription(String iDescription) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s description %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(iDescription));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setCollate(String collate) {
        if (collate == null) {
            collate = "default";
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s collate %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(collate));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public void clearCustom() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s custom clear", this.getFullNameQuoted());
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setCustom(String name, String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter property %s custom %s=%s", this.getFullNameQuoted(), name, OPropertyRemote.quoteString(value));
            ODatabaseDocumentInternal database = this.getDatabase();
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setRegexp(String regexp) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s regexp %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(regexp));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setLinkedClass(OClass linkedClass) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        OPropertyRemote.checkSupportLinkedClass(this.getType());
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s linkedclass %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(linkedClass.getName()));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setLinkedType(OType linkedType) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        OPropertyRemote.checkLinkTypeSupport(this.getType());
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s linkedtype %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(linkedType.toString()));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setNotNull(boolean isNotNull) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s notnull %s", this.getFullNameQuoted(), isNotNull);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setDefaultValue(String defaultValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s default %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(defaultValue));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMax(String max) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s max %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(max));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMin(String min) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s min %s", this.getFullNameQuoted(), OPropertyRemote.quoteString(min));
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setReadonly(boolean isReadonly) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s readonly %s", this.getFullNameQuoted(), isReadonly);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMandatory(boolean isMandatory) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            String cmd = String.format("alter property %s mandatory %s", this.getFullNameQuoted(), isMandatory);
            database.command(cmd, new Object[0]).close();
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public OIndex<?> createIndex(String iType) {
        return this.owner.createIndex(this.getFullName(), iType, this.globalRef.getName());
    }

    @Override
    public OIndex<?> createIndex(OClass.INDEX_TYPE iType) {
        return this.createIndex(iType.toString());
    }

    @Override
    public OIndex<?> createIndex(String iType, ODocument metadata) {
        return this.owner.createIndex(this.getFullName(), iType, null, metadata, this.globalRef.getName());
    }

    @Override
    public OIndex<?> createIndex(OClass.INDEX_TYPE iType, ODocument metadata) {
        return this.createIndex(iType.name(), metadata);
    }

    @Override
    public OPropertyImpl dropIndexes() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        OIndexManager indexManager = this.getDatabase().getMetadata().getIndexManager();
        ArrayList relatedIndexes = new ArrayList();
        for (OIndex<?> oIndex : indexManager.getClassIndexes(this.owner.getName())) {
            OIndexDefinition definition = oIndex.getDefinition();
            if (OCollections.indexOf(definition.getFields(), this.globalRef.getName(), new OCaseInsentiveComparator()) <= -1) continue;
            if (definition instanceof OPropertyIndexDefinition) {
                relatedIndexes.add(oIndex);
                continue;
            }
            throw new IllegalArgumentException("This operation applicable only for property indexes. " + oIndex.getName() + " is " + oIndex.getDefinition());
        }
        for (OIndex<Object> oIndex : relatedIndexes) {
            this.getDatabase().getMetadata().getIndexManager().dropIndex(oIndex.getName());
        }
        return this;
    }
}

