/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassEmbedded;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.SchemaSnapshotOnIndexesUpdateListener;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class OSchemaEmbedded
extends OSchemaShared {
    public OSchemaEmbedded(OSharedContext sharedContext) {
        sharedContext.registerListener(new SchemaSnapshotOnIndexesUpdateListener(this));
    }

    @Override
    public OClass createClass(ODatabaseDocumentInternal database, String className, int[] clusterIds, OClass ... superClasses) {
        OClass result;
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(className);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + className + "'");
        }
        int retry = 0;
        while (true) {
            try {
                result = this.doCreateClass(database, className, clusterIds, retry, superClasses);
            }
            catch (OSchemaShared.ClusterIdsAreEmptyException ignore) {
                this.classes.remove(className.toLowerCase(Locale.ENGLISH));
                clusterIds = this.createClusters(database, className);
                ++retry;
                continue;
            }
            break;
        }
        return result;
    }

    @Override
    public OClass createClass(ODatabaseDocumentInternal database, String className, int clusters, OClass ... superClasses) {
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(className);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + className + "'");
        }
        return this.doCreateClass(database, className, clusters, superClasses);
    }

    private OClass doCreateClass(ODatabaseDocumentInternal database, String className, int clusters, OClass ... superClasses) {
        OClass result;
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        if (superClasses != null) {
            OClassImpl.checkParametersConflict(Arrays.asList(superClasses));
        }
        this.acquireSchemaWriteLock(database);
        try {
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            if (this.executeThroughDistributedStorage(database)) {
                OStorage storage = database.getStorage();
                OClass[] cmd = new StringBuilder("create class ");
                cmd.append('`');
                cmd.append(className);
                cmd.append('`');
                ArrayList<OClass> superClassesList = new ArrayList<OClass>();
                if (superClasses != null && superClasses.length > 0) {
                    boolean first = true;
                    for (OClass superClass : superClasses) {
                        if (superClass == null) continue;
                        if (first) {
                            cmd.append(" extends ");
                        } else {
                            cmd.append(", ");
                        }
                        cmd.append(superClass.getName());
                        first = false;
                        superClassesList.add(superClass);
                    }
                }
                if (clusters == 0) {
                    cmd.append(" abstract");
                }
                int[] clusterIds = this.createClusters(database, className, clusters);
                this.createClassInternal(database, className, clusterIds, superClassesList);
                if (clusters > 0) {
                    cmd.append(" cluster ");
                    for (int i = 0; i < clusterIds.length; ++i) {
                        if (i > 0) {
                            cmd.append(',');
                        } else {
                            cmd.append(' ');
                        }
                        cmd.append(clusterIds[i]);
                    }
                }
                OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)((Object)storage);
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
                Object res = database.command(commandSQL).execute(new Object[0]);
            } else {
                ArrayList<OClass> superClassesList = new ArrayList<OClass>();
                if (superClasses != null && superClasses.length > 0) {
                    for (OClass superClass : superClasses) {
                        if (superClass == null) continue;
                        superClassesList.add(superClass);
                    }
                }
                int[] clusterIds = this.createClusters(database, className, clusters);
                this.createClassInternal(database, className, clusterIds, superClassesList);
            }
            result = (OClass)this.classes.get(className.toLowerCase(Locale.ENGLISH));
            Iterator<Object> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreateClass(database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateClass(database, result);
            }
        }
        catch (OSchemaShared.ClusterIdsAreEmptyException e) {
            throw OException.wrapException(new OSchemaException("Cannot create class '" + className + "'"), e);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass createClassInternal(ODatabaseDocumentInternal database, String className, int[] clusterIdsToAdd, List<OClass> superClasses) throws OSchemaShared.ClusterIdsAreEmptyException {
        this.acquireSchemaWriteLock(database);
        try {
            if (className == null || className.length() == 0) {
                throw new OSchemaException("Found class name null or empty");
            }
            this.checkEmbedded();
            this.checkClustersAreAbsent(clusterIdsToAdd);
            if (clusterIdsToAdd == null || clusterIdsToAdd.length == 0) {
                throw new OSchemaShared.ClusterIdsAreEmptyException();
            }
            int[] clusterIds = clusterIdsToAdd;
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key)) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            OClassImpl cls = this.createClassInstance(className, clusterIds);
            this.classes.put(key, cls);
            if (superClasses != null && superClasses.size() > 0) {
                cls.setSuperClassesInternal(superClasses);
                for (OClass superClass : superClasses) {
                    int[] clustersToIndex = superClass.getPolymorphicClusterIds();
                    String[] clusterNames = new String[clustersToIndex.length];
                    for (int i = 0; i < clustersToIndex.length; ++i) {
                        clusterNames[i] = database.getClusterNameById(clustersToIndex[i]);
                    }
                    for (OIndex<?> index : superClass.getIndexes()) {
                        for (String clusterName : clusterNames) {
                            if (clusterName == null) continue;
                            database.getMetadata().getIndexManager().addClusterToIndex(clusterName, index.getName());
                        }
                    }
                }
            }
            this.addClusterClassMap(cls);
            OClassImpl oClassImpl = cls;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    protected OClassImpl createClassInstance(String className, int[] clusterIds) {
        return new OClassEmbedded((OSchemaShared)this, className, clusterIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OClass getOrCreateClass(ODatabaseDocumentInternal database, String iClassName, OClass ... superClasses) {
        OClass cls;
        if (iClassName == null) {
            return null;
        }
        this.acquireSchemaReadLock();
        try {
            cls = (OClass)this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
            if (cls != null) {
                OClass oClass = cls;
                return oClass;
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
        int[] clusterIds = null;
        int retry = 0;
        while (true) {
            try {
                this.acquireSchemaWriteLock(database);
                try {
                    cls = (OClass)this.classes.get(iClassName.toLowerCase(Locale.ENGLISH));
                    if (cls != null) {
                        OClass oClass = cls;
                        return oClass;
                    }
                    cls = this.doCreateClass(database, iClassName, clusterIds, retry, superClasses);
                    this.addClusterClassMap(cls);
                    return cls;
                }
                finally {
                    this.releaseSchemaWriteLock(database);
                }
            }
            catch (OSchemaShared.ClusterIdsAreEmptyException ignore) {
                clusterIds = this.createClusters(database, iClassName);
                ++retry;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass doCreateClass(ODatabaseDocumentInternal database, String className, int[] clusterIds, int retry, OClass ... superClasses) throws OSchemaShared.ClusterIdsAreEmptyException {
        OClass result;
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_CREATE, new Object[0]);
        if (superClasses != null) {
            OClassImpl.checkParametersConflict(Arrays.asList(superClasses));
        }
        this.acquireSchemaWriteLock(database);
        try {
            String key = className.toLowerCase(Locale.ENGLISH);
            if (this.classes.containsKey(key) && retry == 0) {
                throw new OSchemaException("Class '" + className + "' already exists in current database");
            }
            if (!this.executeThroughDistributedStorage(database)) {
                this.checkClustersAreAbsent(clusterIds);
            }
            if (clusterIds == null || clusterIds.length == 0) {
                clusterIds = this.createClusters(database, className, database.getStorage().getConfiguration().getMinimumClusters());
            }
            if (this.executeThroughDistributedStorage(database)) {
                OStorage storage = database.getStorage();
                StringBuilder cmd = new StringBuilder("create class ");
                cmd.append('`');
                cmd.append(className);
                cmd.append('`');
                ArrayList<OClass> superClassesList = new ArrayList<OClass>();
                if (superClasses != null && superClasses.length > 0) {
                    boolean first = true;
                    for (OClass superClass : superClasses) {
                        if (superClass == null) continue;
                        if (first) {
                            cmd.append(" extends ");
                        } else {
                            cmd.append(", ");
                        }
                        cmd.append('`').append(superClass.getName()).append('`');
                        first = false;
                        superClassesList.add(superClass);
                    }
                }
                if (clusterIds != null) {
                    if (clusterIds.length == 1 && clusterIds[0] == -1) {
                        cmd.append(" abstract");
                    } else {
                        cmd.append(" cluster ");
                        for (int i = 0; i < clusterIds.length; ++i) {
                            if (i > 0) {
                                cmd.append(',');
                            } else {
                                cmd.append(' ');
                            }
                            cmd.append(clusterIds[i]);
                        }
                    }
                }
                this.createClassInternal(database, className, clusterIds, superClassesList);
                OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)((Object)storage);
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
                Object res = database.command(commandSQL).execute(new Object[0]);
            } else {
                ArrayList<OClass> superClassesList = new ArrayList<OClass>();
                if (superClasses != null && superClasses.length > 0) {
                    for (OClass superClass : superClasses) {
                        if (superClass == null) continue;
                        superClassesList.add(superClass);
                    }
                }
                this.createClassInternal(database, className, clusterIds, superClassesList);
            }
            result = (OClass)this.classes.get(className.toLowerCase(Locale.ENGLISH));
            Iterator<Object> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onCreateClass(database, result);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onCreateClass(database, result);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
        return result;
    }

    private int[] createClusters(ODatabaseDocumentInternal database, String iClassName) {
        return this.createClusters(database, iClassName, database.getStorage().getConfiguration().getMinimumClusters());
    }

    private int[] createClusters(ODatabaseDocumentInternal database, String className, int minimumClusters) {
        if (internalClasses.contains((className = className.toLowerCase(Locale.ENGLISH)).toLowerCase(Locale.ENGLISH))) {
            minimumClusters = 1;
        }
        int[] clusterIds = new int[minimumClusters];
        clusterIds[0] = database.getClusterIdByName(className);
        if (clusterIds[0] > -1) {
            OClass cls = (OClass)this.clustersToClasses.get(clusterIds[0]);
            if (cls != null) {
                clusterIds[0] = database.addCluster(this.getNextAvailableClusterName(database, className), new Object[0]);
            }
        } else {
            clusterIds[0] = database.addCluster(className, new Object[0]);
        }
        for (int i = 1; i < minimumClusters; ++i) {
            clusterIds[i] = database.addCluster(this.getNextAvailableClusterName(database, className), new Object[0]);
        }
        return clusterIds;
    }

    private String getNextAvailableClusterName(ODatabaseDocumentInternal database, String className) {
        int i = 1;
        String clusterName;
        while (database.getClusterIdByName(clusterName = className + "_" + i) >= 0) {
            ++i;
        }
        return clusterName;
    }

    private void checkClustersAreAbsent(int[] iClusterIds) {
        if (iClusterIds == null) {
            return;
        }
        for (int clusterId : iClusterIds) {
            if (clusterId < 0 || !this.clustersToClasses.containsKey(clusterId)) continue;
            throw new OSchemaException("Cluster with id " + clusterId + " already belongs to class " + this.clustersToClasses.get(clusterId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropClass(ODatabaseDocumentInternal database, String className) {
        OStorage storage = database.getStorage();
        this.acquireSchemaWriteLock(database);
        try {
            if (database.getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (className == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            OClass cls = (OClass)this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class '" + className + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("Class '" + className + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            if (this.executeThroughDistributedStorage(database)) {
                StringBuilder cmd = new StringBuilder("drop class ");
                cmd.append(className);
                cmd.append(" unsafe");
                OAutoshardedStorage autoshardedStorage = (OAutoshardedStorage)((Object)storage);
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                commandSQL.addExcludedNode(autoshardedStorage.getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.dropClassInternal(database, className);
            } else {
                this.dropClassInternal(database, className);
            }
            database.getLocalCache().freeCluster(cls.getDefaultClusterId());
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropClassInternal(ODatabaseDocumentInternal database, String className) {
        this.acquireSchemaWriteLock(database);
        try {
            if (database.getTransaction().isActive()) {
                throw new IllegalStateException("Cannot drop a class inside a transaction");
            }
            if (className == null) {
                throw new IllegalArgumentException("Class name is null");
            }
            database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
            String key = className.toLowerCase(Locale.ENGLISH);
            OClass cls = (OClass)this.classes.get(key);
            if (cls == null) {
                throw new OSchemaException("Class '" + className + "' was not found in current database");
            }
            if (!cls.getSubclasses().isEmpty()) {
                throw new OSchemaException("Class '" + className + "' cannot be dropped because it has sub classes " + cls.getSubclasses() + ". Remove the dependencies before trying to drop it again");
            }
            this.checkEmbedded();
            for (OClass superClass : cls.getSuperClasses()) {
                ((OClassImpl)superClass).removeBaseClassInternal(cls);
            }
            for (Object id : (Object)cls.getClusterIds()) {
                if (id == -1) continue;
                this.deleteCluster(database, (int)id);
            }
            this.dropClassIndexes(database, cls);
            this.classes.remove(key);
            if (cls.getShortName() != null) {
                this.classes.remove(cls.getShortName().toLowerCase(Locale.ENGLISH));
            }
            this.removeClusterClassMap(cls);
            Iterator<Object> it = Orient.instance().getDbLifecycleListeners();
            while (it.hasNext()) {
                it.next().onDropClass(database, cls);
            }
            it = database.getListeners().iterator();
            while (it.hasNext()) {
                ((ODatabaseListener)it.next()).onDropClass(database, cls);
            }
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    @Override
    protected OClassImpl createClassInstance(ODocument c) {
        return new OClassEmbedded((OSchemaShared)this, c, (String)c.field("name"));
    }

    private void dropClassIndexes(ODatabaseDocumentInternal database, OClass cls) {
        OIndexManager indexManager = database.getMetadata().getIndexManager();
        for (OIndex<?> index : indexManager.getClassIndexes(cls.getName())) {
            indexManager.dropIndex(index.getName());
        }
    }

    private void deleteCluster(ODatabaseDocumentInternal db, int clusterId) {
        db.getStorage().dropCluster(clusterId, false);
        db.getLocalCache().freeCluster(clusterId);
    }

    private void removeClusterClassMap(OClass cls) {
        for (int clusterId : cls.getClusterIds()) {
            if (clusterId < 0) continue;
            this.clustersToClasses.remove(clusterId);
        }
    }

    @Override
    public void checkEmbedded() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addClusterForClass(ODatabaseDocumentInternal database, int clusterId, OClass cls) {
        this.acquireSchemaWriteLock(database);
        try {
            if (clusterId < 0) {
                return;
            }
            this.checkEmbedded();
            OClass existingCls = (OClass)this.clustersToClasses.get(clusterId);
            if (existingCls != null && !cls.equals(existingCls)) {
                throw new OSchemaException("Cluster with id " + clusterId + " already belongs to class " + this.clustersToClasses.get(clusterId));
            }
            this.clustersToClasses.put(clusterId, cls);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeClusterForClass(ODatabaseDocumentInternal database, int clusterId, OClass cls) {
        this.acquireSchemaWriteLock(database);
        try {
            if (clusterId < 0) {
                return;
            }
            this.checkEmbedded();
            this.clustersToClasses.remove(clusterId);
        }
        finally {
            this.releaseSchemaWriteLock(database);
        }
    }
}

