/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.executor.AbstractTraverseStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OTraverseResult;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OTraverseProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class BreadthFirstTraverseStep
extends AbstractTraverseStep {
    public BreadthFirstTraverseStep(List<OTraverseProjectionItem> projections, OWhereClause whileClause, OInteger maxDepth, OCommandContext ctx, boolean profilingEnabled) {
        super(projections, whileClause, maxDepth, ctx, profilingEnabled);
    }

    @Override
    protected void fetchNextEntryPoints(OCommandContext ctx, int nRecords) {
        OResultSet nextN = this.getPrev().get().syncPull(ctx, nRecords);
        while (nextN.hasNext()) {
            while (nextN.hasNext()) {
                OResult item = this.toTraverseResult(nextN.next());
                if (item == null) continue;
                ArrayList stack = new ArrayList();
                item.getIdentity().ifPresent(x -> stack.add(x));
                ((OResultInternal)item).setMetadata("$stack", stack);
                ArrayList<ORID> path = new ArrayList<ORID>();
                path.add(item.getIdentity().get());
                ((OResultInternal)item).setMetadata("$path", path);
                if (!item.isElement() || this.traversed.contains(item.getElement().get().getIdentity())) continue;
                this.tryAddEntryPoint(item, ctx);
            }
            nextN = this.getPrev().get().syncPull(ctx, nRecords);
        }
    }

    private OResult toTraverseResult(OResult item) {
        OTraverseResult res = null;
        if (item instanceof OTraverseResult) {
            res = (OTraverseResult)item;
        } else if (item.isElement() && item.getElement().get().getIdentity().isPersistent()) {
            res = new OTraverseResult();
            res.setElement(item.getElement().get());
            res.depth = 0;
            res.setMetadata("$depth", 0);
        } else {
            return null;
        }
        return res;
    }

    @Override
    protected void fetchNextResults(OCommandContext ctx, int nRecords) {
        if (!this.entryPoints.isEmpty()) {
            OTraverseResult item = (OTraverseResult)this.entryPoints.remove(0);
            this.results.add(item);
            for (OTraverseProjectionItem proj : this.projections) {
                Object nextStep = proj.execute(item, ctx);
                if (this.maxDepth != null && this.maxDepth.getValue().intValue() <= item.depth) continue;
                this.addNextEntryPoints(nextStep, item.depth + 1, (List<OIdentifiable>)((List)item.getMetadata("$path")), ctx);
            }
        }
    }

    private void addNextEntryPoints(Object nextStep, int depth, List<OIdentifiable> path, OCommandContext ctx) {
        if (nextStep instanceof OIdentifiable) {
            this.addNextEntryPoints((OIdentifiable)nextStep, depth, path, ctx);
        } else if (nextStep instanceof Iterable) {
            this.addNextEntryPoints(((Iterable)nextStep).iterator(), depth, path, ctx);
        } else if (nextStep instanceof OResult) {
            this.addNextEntryPoints((OResult)nextStep, depth, path, ctx);
        }
    }

    private void addNextEntryPoints(Iterator nextStep, int depth, List<OIdentifiable> path, OCommandContext ctx) {
        while (nextStep.hasNext()) {
            this.addNextEntryPoints(nextStep.next(), depth, path, ctx);
        }
    }

    private void addNextEntryPoints(OIdentifiable nextStep, int depth, List<OIdentifiable> path, OCommandContext ctx) {
        if (this.traversed.contains(nextStep.getIdentity())) {
            return;
        }
        OTraverseResult res = new OTraverseResult();
        res.setElement(nextStep);
        res.depth = depth;
        res.setMetadata("$depth", depth);
        ArrayList<OIdentifiable> newPath = new ArrayList<OIdentifiable>();
        newPath.addAll(path);
        newPath.add(res.getIdentity().get());
        res.setMetadata("$path", newPath);
        ArrayList<OIdentifiable> reverseStack = new ArrayList<OIdentifiable>();
        reverseStack.addAll(newPath);
        Collections.reverse(reverseStack);
        ArrayList<OIdentifiable> newStack = new ArrayList<OIdentifiable>();
        newStack.addAll(reverseStack);
        res.setMetadata("$stack", newStack);
        this.tryAddEntryPoint(res, ctx);
    }

    private void addNextEntryPoints(OResult nextStep, int depth, List<OIdentifiable> path, OCommandContext ctx) {
        if (!nextStep.isElement()) {
            return;
        }
        if (this.traversed.contains(nextStep.getElement().get().getIdentity())) {
            return;
        }
        if (nextStep instanceof OTraverseResult) {
            ((OTraverseResult)nextStep).depth = depth;
            ((OTraverseResult)nextStep).setMetadata("$depth", depth);
            ArrayList<OIdentifiable> newPath = new ArrayList<OIdentifiable>();
            newPath.addAll(path);
            newPath.add(((OTraverseResult)nextStep).getIdentity().get());
            ((OTraverseResult)nextStep).setMetadata("$path", newPath);
            ArrayList<OIdentifiable> reverseStack = new ArrayList<OIdentifiable>();
            reverseStack.addAll(newPath);
            Collections.reverse(reverseStack);
            ArrayList<OIdentifiable> newStack = new ArrayList<OIdentifiable>();
            newStack.addAll(reverseStack);
            ((OTraverseResult)nextStep).setMetadata("$stack", newStack);
            this.tryAddEntryPoint(nextStep, ctx);
        } else {
            OTraverseResult res = new OTraverseResult();
            res.setElement(nextStep.getElement().get());
            res.depth = depth;
            res.setMetadata("$depth", depth);
            ArrayList<OIdentifiable> newPath = new ArrayList<OIdentifiable>();
            newPath.addAll(path);
            newPath.add(((OTraverseResult)nextStep).getIdentity().get());
            ((OTraverseResult)nextStep).setMetadata("$path", newPath);
            ArrayList<OIdentifiable> reverseStack = new ArrayList<OIdentifiable>();
            reverseStack.addAll(newPath);
            Collections.reverse(reverseStack);
            ArrayDeque<OIdentifiable> newStack = new ArrayDeque<OIdentifiable>();
            newStack.addAll(reverseStack);
            ((OTraverseResult)nextStep).setMetadata("$stack", newStack);
            this.tryAddEntryPoint(res, ctx);
        }
    }

    private void tryAddEntryPoint(OResult res, OCommandContext ctx) {
        if (this.whileClause == null || this.whileClause.matchesFilters(res, ctx)) {
            this.entryPoints.add(res);
        }
        this.traversed.add(res.getElement().get().getIdentity());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ BREADTH-FIRST TRAVERSE \n");
        if (this.whileClause != null) {
            result.append(spaces);
            result.append("WHILE " + this.whileClause.toString());
        }
        return result.toString();
    }
}

