/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Map;
import java.util.Optional;

public class CheckRecordTypeStep
extends AbstractExecutionStep {
    private final String clazz;
    private long cost = 0L;

    public CheckRecordTypeStep(OCommandContext ctx, String className, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.clazz = className;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        final OResultSet upstream = ((OExecutionStepInternal)this.prev.get()).syncPull(ctx, nRecords);
        return new OResultSet(){

            @Override
            public boolean hasNext() {
                return upstream.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                OResult result = upstream.next();
                long begin = CheckRecordTypeStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (!result.isElement()) {
                        throw new OCommandExecutionException("record " + result + " is not an instance of " + CheckRecordTypeStep.this.clazz);
                    }
                    OElement doc = result.getElement().get();
                    if (doc == null) {
                        throw new OCommandExecutionException("record " + result + " is not an instance of " + CheckRecordTypeStep.this.clazz);
                    }
                    Optional<OClass> schema = doc.getSchemaType();
                    if (!schema.isPresent() || !schema.get().isSubClassOf(CheckRecordTypeStep.this.clazz)) {
                        throw new OCommandExecutionException("record " + result + " is not an instance of " + CheckRecordTypeStep.this.clazz);
                    }
                    OResult oResult = result;
                    return oResult;
                }
                finally {
                    if (CheckRecordTypeStep.this.profilingEnabled) {
                        CheckRecordTypeStep.this.cost = CheckRecordTypeStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
                upstream.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ CHECK RECORD TYPE";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        result = result + OExecutionStepInternal.getIndent(depth, indent) + "  " + this.clazz;
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

