/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import java.util.Map;
import java.util.Optional;

public class CreateRecordStep
extends AbstractExecutionStep {
    private long cost = 0L;
    int created = 0;
    int total = 0;

    public CreateRecordStep(OCommandContext ctx, int total, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.total = total;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){
            int locallyCreated = 0;

            @Override
            public boolean hasNext() {
                if (this.locallyCreated >= nRecords) {
                    return false;
                }
                return CreateRecordStep.this.created < CreateRecordStep.this.total;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                long begin = CreateRecordStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    if (!this.hasNext()) {
                        throw new IllegalStateException();
                    }
                    ++CreateRecordStep.this.created;
                    ++this.locallyCreated;
                    OUpdatableResult oUpdatableResult = new OUpdatableResult((ODocument)ctx.getDatabase().newInstance());
                    return oUpdatableResult;
                }
                finally {
                    if (CreateRecordStep.this.profilingEnabled) {
                        CreateRecordStep.this.cost = CreateRecordStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ CREATE EMPTY RECORDS");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        result.append("\n");
        result.append(spaces);
        if (this.total == 1) {
            result.append("  1 record");
        } else {
            result.append("  " + this.total + " record");
        }
        return result.toString();
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

