/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLimit;

public class LimitExecutionStep
extends AbstractExecutionStep {
    private final OLimit limit;
    int loaded = 0;

    public LimitExecutionStep(OLimit limit, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.limit = limit;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        int limitVal = this.limit.getValue(ctx);
        if (limitVal == -1) {
            return this.getPrev().get().syncPull(ctx, nRecords);
        }
        if (limitVal <= this.loaded) {
            return new OInternalResultSet();
        }
        int nextBlockSize = Math.min(nRecords, limitVal - this.loaded);
        OResultSet result = ((OExecutionStepInternal)this.prev.get()).syncPull(ctx, nextBlockSize);
        this.loaded += nextBlockSize;
        return result;
    }

    @Override
    public void sendTimeout() {
    }

    @Override
    public void close() {
        this.prev.ifPresent(x -> x.close());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        return OExecutionStepInternal.getIndent(depth, indent) + "+ LIMIT (" + this.limit.toString() + ")";
    }
}

