/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface OResultSet
extends Spliterator<OResult>,
Iterator<OResult>,
AutoCloseable {
    @Override
    public boolean hasNext();

    @Override
    public OResult next();

    @Override
    default public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close();

    public Optional<OExecutionPlan> getExecutionPlan();

    public Map<String, Long> getQueryStats();

    default public void reset() {
        throw new UnsupportedOperationException("Implement RESET on " + this.getClass().getSimpleName());
    }

    @Override
    default public boolean tryAdvance(Consumer<? super OResult> action) {
        if (this.hasNext()) {
            action.accept(this.next());
            return true;
        }
        return false;
    }

    @Override
    default public void forEachRemaining(Consumer<? super OResult> action) {
        Spliterator.super.forEachRemaining(action);
    }

    default public OResultSet trySplit() {
        return null;
    }

    @Override
    default public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    default public int characteristics() {
        return 16;
    }

    default public Stream<OResult> stream() {
        return (Stream)StreamSupport.stream(this, false).onClose(() -> this.close());
    }

    default public Stream<OElement> elementStream() {
        return (Stream)StreamSupport.stream(new Spliterator<OElement>(){

            @Override
            public boolean tryAdvance(Consumer<? super OElement> action) {
                while (OResultSet.this.hasNext()) {
                    OResult elem = OResultSet.this.next();
                    if (!elem.isElement()) continue;
                    action.accept(elem.getElement().get());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<OElement> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 16;
            }
        }, false).onClose(() -> this.close());
    }

    default public Stream<OVertex> vertexStream() {
        return (Stream)StreamSupport.stream(new Spliterator<OVertex>(){

            @Override
            public boolean tryAdvance(Consumer<? super OVertex> action) {
                while (OResultSet.this.hasNext()) {
                    OResult elem = OResultSet.this.next();
                    if (!elem.isVertex()) continue;
                    action.accept(elem.getVertex().get());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<OVertex> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 16;
            }
        }, false).onClose(() -> this.close());
    }

    default public Stream<OEdge> edgeStream() {
        return (Stream)StreamSupport.stream(new Spliterator<OEdge>(){

            @Override
            public boolean tryAdvance(Consumer<? super OEdge> action) {
                while (OResultSet.this.hasNext()) {
                    OResult nextElem = OResultSet.this.next();
                    if (nextElem == null || !nextElem.isEdge()) continue;
                    action.accept(nextElem.getEdge().get());
                    return true;
                }
                return false;
            }

            @Override
            public Spliterator<OEdge> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return Long.MAX_VALUE;
            }

            @Override
            public int characteristics() {
                return 16;
            }
        }, false).onClose(() -> this.close());
    }
}

