/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.CheckRecordTypeStep;
import com.orientechnologies.orient.core.sql.executor.ConvertToResultInternalStep;
import com.orientechnologies.orient.core.sql.executor.ConvertToUpdatableResultStep;
import com.orientechnologies.orient.core.sql.executor.CopyRecordContentBeforeUpdateStep;
import com.orientechnologies.orient.core.sql.executor.CountStep;
import com.orientechnologies.orient.core.sql.executor.LimitExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.ProjectionCalculationStep;
import com.orientechnologies.orient.core.sql.executor.SaveElementStep;
import com.orientechnologies.orient.core.sql.executor.SubQueryStep;
import com.orientechnologies.orient.core.sql.executor.TimeoutStep;
import com.orientechnologies.orient.core.sql.executor.UnwrapPreviousValueStep;
import com.orientechnologies.orient.core.sql.executor.UpdateContentStep;
import com.orientechnologies.orient.core.sql.executor.UpdateEdgePointersStep;
import com.orientechnologies.orient.core.sql.executor.UpdateMergeStep;
import com.orientechnologies.orient.core.sql.executor.UpdateRemoveStep;
import com.orientechnologies.orient.core.sql.executor.UpdateSetStep;
import com.orientechnologies.orient.core.sql.executor.UpsertStep;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import com.orientechnologies.orient.core.sql.parser.OUpdateEdgeStatement;
import com.orientechnologies.orient.core.sql.parser.OUpdateOperations;
import com.orientechnologies.orient.core.sql.parser.OUpdateStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OUpdateExecutionPlanner {
    private final OFromClause target;
    public OWhereClause whereClause;
    protected boolean upsert = false;
    protected List<OUpdateOperations> operations = new ArrayList<OUpdateOperations>();
    protected boolean returnBefore = false;
    protected boolean returnAfter = false;
    protected boolean returnCount = false;
    protected boolean updateEdge = false;
    protected OProjection returnProjection;
    public OStorage.LOCKING_STRATEGY lockRecord = null;
    public OLimit limit;
    public OTimeout timeout;

    public OUpdateExecutionPlanner(OUpdateStatement oUpdateStatement) {
        if (oUpdateStatement instanceof OUpdateEdgeStatement) {
            this.updateEdge = true;
        }
        this.target = oUpdateStatement.getTarget().copy();
        this.whereClause = oUpdateStatement.getWhereClause() == null ? null : oUpdateStatement.getWhereClause().copy();
        this.operations = oUpdateStatement.getOperations() == null ? null : oUpdateStatement.getOperations().stream().map(x -> x.copy()).collect(Collectors.toList());
        this.upsert = oUpdateStatement.isUpsert();
        this.returnBefore = oUpdateStatement.isReturnBefore();
        this.returnAfter = oUpdateStatement.isReturnAfter();
        this.returnCount = !this.returnAfter && !this.returnBefore;
        this.returnProjection = oUpdateStatement.getReturnProjection() == null ? null : oUpdateStatement.getReturnProjection().copy();
        this.lockRecord = oUpdateStatement.getLockRecord();
        this.limit = oUpdateStatement.getLimit() == null ? null : oUpdateStatement.getLimit().copy();
        this.timeout = oUpdateStatement.getTimeout() == null ? null : oUpdateStatement.getTimeout().copy();
    }

    public OUpdateExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OUpdateExecutionPlan result = new OUpdateExecutionPlan(ctx);
        this.handleTarget(result, ctx, this.target, this.whereClause, this.timeout, enableProfiling);
        if (this.updateEdge) {
            result.chain(new CheckRecordTypeStep(ctx, "E", enableProfiling));
        }
        this.handleUpsert(result, ctx, this.target, this.whereClause, this.upsert, enableProfiling);
        this.handleTimeout(result, ctx, this.timeout, enableProfiling);
        this.convertToModifiableResult(result, ctx, enableProfiling);
        this.handleLimit(result, ctx, this.limit, enableProfiling);
        this.handleReturnBefore(result, ctx, this.returnBefore, enableProfiling);
        this.handleOperations(result, ctx, this.operations, enableProfiling);
        this.handleLock(result, ctx, this.lockRecord);
        this.handleSave(result, ctx, enableProfiling);
        this.handleResultForReturnBefore(result, ctx, this.returnBefore, this.returnProjection, enableProfiling);
        this.handleResultForReturnAfter(result, ctx, this.returnAfter, this.returnProjection, enableProfiling);
        this.handleResultForReturnCount(result, ctx, this.returnCount, enableProfiling);
        return result;
    }

    private void convertToModifiableResult(OUpdateExecutionPlan plan, OCommandContext ctx, boolean profilingEnabled) {
        plan.chain(new ConvertToUpdatableResultStep(ctx, profilingEnabled));
    }

    private void handleResultForReturnCount(OUpdateExecutionPlan result, OCommandContext ctx, boolean returnCount, boolean profilingEnabled) {
        if (returnCount) {
            result.chain(new CountStep(ctx, profilingEnabled));
        }
    }

    private void handleResultForReturnAfter(OUpdateExecutionPlan result, OCommandContext ctx, boolean returnAfter, OProjection returnProjection, boolean profilingEnabled) {
        if (returnAfter) {
            result.chain(new ConvertToResultInternalStep(ctx, profilingEnabled));
            if (returnProjection != null) {
                result.chain(new ProjectionCalculationStep(returnProjection, ctx, profilingEnabled));
            }
        }
    }

    private void handleResultForReturnBefore(OUpdateExecutionPlan result, OCommandContext ctx, boolean returnBefore, OProjection returnProjection, boolean profilingEnabled) {
        if (returnBefore) {
            result.chain(new UnwrapPreviousValueStep(ctx, profilingEnabled));
            if (returnProjection != null) {
                result.chain(new ProjectionCalculationStep(returnProjection, ctx, profilingEnabled));
            }
        }
    }

    private void handleSave(OUpdateExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new SaveElementStep(ctx, profilingEnabled));
    }

    private void handleTimeout(OUpdateExecutionPlan result, OCommandContext ctx, OTimeout timeout, boolean profilingEnabled) {
        if (timeout != null && timeout.getVal().longValue() > 0L) {
            result.chain(new TimeoutStep(timeout, ctx, profilingEnabled));
        }
    }

    private void handleReturnBefore(OUpdateExecutionPlan result, OCommandContext ctx, boolean returnBefore, boolean profilingEnabled) {
        if (returnBefore) {
            result.chain(new CopyRecordContentBeforeUpdateStep(ctx, profilingEnabled));
        }
    }

    private void handleLock(OUpdateExecutionPlan result, OCommandContext ctx, OStorage.LOCKING_STRATEGY lockRecord) {
    }

    private void handleLimit(OUpdateExecutionPlan plan, OCommandContext ctx, OLimit limit, boolean profilingEnabled) {
        if (limit != null) {
            plan.chain(new LimitExecutionStep(limit, ctx, profilingEnabled));
        }
    }

    private void handleUpsert(OUpdateExecutionPlan plan, OCommandContext ctx, OFromClause target, OWhereClause where, boolean upsert, boolean profilingEnabled) {
        if (upsert) {
            plan.chain(new UpsertStep(target, where, ctx, profilingEnabled));
        }
    }

    private void handleOperations(OUpdateExecutionPlan plan, OCommandContext ctx, List<OUpdateOperations> ops, boolean profilingEnabled) {
        if (ops != null) {
            for (OUpdateOperations op : ops) {
                switch (op.getType()) {
                    case 0: {
                        plan.chain(new UpdateSetStep(op.getUpdateItems(), ctx, profilingEnabled));
                        if (!this.updateEdge) break;
                        plan.chain(new UpdateEdgePointersStep(ctx, profilingEnabled));
                        break;
                    }
                    case 6: {
                        plan.chain(new UpdateRemoveStep(op.getUpdateRemoveItems(), ctx, profilingEnabled));
                        break;
                    }
                    case 2: {
                        plan.chain(new UpdateMergeStep(op.getJson(), ctx, profilingEnabled));
                        break;
                    }
                    case 3: {
                        plan.chain(new UpdateContentStep(op.getJson(), ctx, profilingEnabled));
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        throw new OCommandExecutionException("Cannot execute with UPDATE PUT/ADD/INCREMENT new executor: " + op);
                    }
                }
            }
        }
    }

    private void handleTarget(OUpdateExecutionPlan result, OCommandContext ctx, OFromClause target, OWhereClause whereClause, OTimeout timeout, boolean profilingEnabled) {
        OSelectStatement sourceStatement = new OSelectStatement(-1);
        sourceStatement.setTarget(target);
        sourceStatement.setWhereClause(whereClause);
        if (timeout != null) {
            sourceStatement.setTimeout(this.timeout.copy());
        }
        OSelectExecutionPlanner planner = new OSelectExecutionPlanner(sourceStatement);
        result.chain(new SubQueryStep(planner.createExecutionPlan(ctx, profilingEnabled, false), ctx, ctx, profilingEnabled));
    }
}

