/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OIndexMatchCondition
extends OBooleanExpression {
    protected OBinaryCompareOperator operator;
    protected Boolean between;
    protected List<OExpression> leftExpressions;
    protected List<OExpression> rightExpressions;

    public OIndexMatchCondition(int id) {
        super(id);
    }

    public OIndexMatchCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        throw new UnsupportedOperationException("TODO Implement IndexMatch!!!");
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        throw new UnsupportedOperationException("TODO Implement IndexMatch!!!");
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("KEY ");
        if (this.operator != null) {
            builder.append(this.operator.toString());
            builder.append(" [");
            boolean first = true;
            for (OExpression x : this.leftExpressions) {
                if (!first) {
                    builder.append(", ");
                }
                x.toString(params, builder);
                first = false;
            }
            builder.append("]");
        } else if (Boolean.TRUE.equals(this.between)) {
            builder.append(" BETWEEN [");
            boolean first = true;
            for (OExpression x : this.leftExpressions) {
                if (!first) {
                    builder.append(", ");
                }
                x.toString(params, builder);
                first = false;
            }
            builder.append("] AND [");
            first = true;
            for (OExpression x : this.rightExpressions) {
                if (!first) {
                    builder.append(", ");
                }
                x.toString(params, builder);
                first = false;
            }
            builder.append("]");
        }
    }

    @Override
    public boolean supportsBasicCalculation() {
        return false;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        return 1;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this);
        return result;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.leftExpressions != null) {
            for (OExpression exp : this.leftExpressions) {
                if (!exp.needsAliases(aliases)) continue;
                return true;
            }
        }
        if (this.rightExpressions != null) {
            for (OExpression exp : this.rightExpressions) {
                if (!exp.needsAliases(aliases)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public OIndexMatchCondition copy() {
        OIndexMatchCondition result = new OIndexMatchCondition(-1);
        result.operator = this.operator == null ? null : this.operator.copy();
        result.between = this.between;
        result.leftExpressions = this.leftExpressions == null ? null : this.leftExpressions.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.rightExpressions = this.rightExpressions == null ? null : this.rightExpressions.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        if (this.leftExpressions != null) {
            for (OExpression exp : this.leftExpressions) {
                exp.extractSubQueries(collector);
            }
        }
        if (this.rightExpressions != null) {
            for (OExpression exp : this.rightExpressions) {
                exp.extractSubQueries(collector);
            }
        }
    }

    @Override
    public boolean refersToParent() {
        if (this.leftExpressions != null) {
            for (OExpression exp : this.leftExpressions) {
                if (exp == null || !exp.refersToParent()) continue;
                return true;
            }
        }
        if (this.rightExpressions != null) {
            for (OExpression exp : this.rightExpressions) {
                if (exp == null || !exp.refersToParent()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexMatchCondition that = (OIndexMatchCondition)o;
        if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
            return false;
        }
        if (this.between != null ? !this.between.equals(that.between) : that.between != null) {
            return false;
        }
        if (this.leftExpressions != null ? !this.leftExpressions.equals(that.leftExpressions) : that.leftExpressions != null) {
            return false;
        }
        return !(this.rightExpressions != null ? !this.rightExpressions.equals(that.rightExpressions) : that.rightExpressions != null);
    }

    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + (this.between != null ? this.between.hashCode() : 0);
        result = 31 * result + (this.leftExpressions != null ? this.leftExpressions.hashCode() : 0);
        result = 31 * result + (this.rightExpressions != null ? this.rightExpressions.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        return null;
    }

    @Override
    public boolean isCacheable() {
        if (this.leftExpressions != null) {
            for (OExpression exp : this.leftExpressions) {
                if (exp.isCacheable()) continue;
                return false;
            }
        }
        if (this.rightExpressions != null) {
            for (OExpression exp : this.rightExpressions) {
                if (exp.isCacheable()) continue;
                return false;
            }
        }
        return true;
    }
}

