/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.OMoveVertexExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OUpdateOperations;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.HashMap;
import java.util.Map;

public class OMoveVertexStatement
extends OStatement {
    protected OFromItem source;
    protected OCluster targetCluster;
    protected OIdentifier targetClass;
    protected OUpdateOperations updateOperations;
    protected OBatch batch;

    public OMoveVertexStatement(int id) {
        super(id);
    }

    public OMoveVertexStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx, boolean usePlanCache) {
        HashMap<Integer, Object> params = new HashMap<Integer, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        return this.execute(db, params, parentCtx, usePlanCache);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx, boolean usePlanCache) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OUpdateExecutionPlan executionPlan = usePlanCache ? this.createExecutionPlan(ctx, false) : (OUpdateExecutionPlan)this.createExecutionPlanNoCache(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OUpdateExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OMoveVertexExecutionPlanner planner = new OMoveVertexExecutionPlanner(this);
        return planner.createExecutionPlan(ctx, enableProfiling);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("MOVE VERTEX ");
        this.source.toString(params, builder);
        builder.append(" TO ");
        if (this.targetCluster != null) {
            this.targetCluster.toString(params, builder);
        } else {
            builder.append("CLASS:");
            this.targetClass.toString(params, builder);
        }
        if (this.updateOperations != null) {
            builder.append(" ");
            this.updateOperations.toString(params, builder);
        }
        if (this.batch != null) {
            builder.append(" ");
            this.batch.toString(params, builder);
        }
    }

    @Override
    public OMoveVertexStatement copy() {
        OMoveVertexStatement result = new OMoveVertexStatement(-1);
        result.source = this.source.copy();
        result.targetClass = this.targetClass == null ? null : this.targetClass.copy();
        result.targetCluster = this.targetCluster == null ? null : this.targetCluster.copy();
        result.updateOperations = this.updateOperations == null ? null : this.updateOperations.copy();
        result.batch = this.batch == null ? null : this.batch.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMoveVertexStatement that = (OMoveVertexStatement)o;
        if (!this.source.equals(that.source)) {
            return false;
        }
        if (this.targetCluster != null ? !this.targetCluster.equals(that.targetCluster) : that.targetCluster != null) {
            return false;
        }
        if (this.targetClass != null ? !this.targetClass.equals(that.targetClass) : that.targetClass != null) {
            return false;
        }
        if (this.updateOperations != null ? !this.updateOperations.equals(that.updateOperations) : that.updateOperations != null) {
            return false;
        }
        return this.batch != null ? this.batch.equals(that.batch) : that.batch == null;
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = 31 * result + (this.targetCluster != null ? this.targetCluster.hashCode() : 0);
        result = 31 * result + (this.targetClass != null ? this.targetClass.hashCode() : 0);
        result = 31 * result + (this.updateOperations != null ? this.updateOperations.hashCode() : 0);
        result = 31 * result + (this.batch != null ? this.batch.hashCode() : 0);
        return result;
    }

    public OFromItem getSource() {
        return this.source;
    }

    public void setSource(OFromItem source) {
        this.source = source;
    }

    public OCluster getTargetCluster() {
        return this.targetCluster;
    }

    public void setTargetCluster(OCluster targetCluster) {
        this.targetCluster = targetCluster;
    }

    public OIdentifier getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(OIdentifier targetClass) {
        this.targetClass = targetClass;
    }

    public OUpdateOperations getUpdateOperations() {
        return this.updateOperations;
    }

    public void setUpdateOperations(OUpdateOperations updateOperations) {
        this.updateOperations = updateOperations;
    }

    public OBatch getBatch() {
        return this.batch;
    }

    public void setBatch(OBatch batch) {
        this.batch = batch;
    }
}

