/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.ONestedProjectionItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ONestedProjection
extends SimpleNode {
    protected List<ONestedProjectionItem> includeItems = new ArrayList<ONestedProjectionItem>();
    protected List<ONestedProjectionItem> excludeItems = new ArrayList<ONestedProjectionItem>();
    protected ONestedProjectionItem starItem;
    private OInteger recursion;

    public ONestedProjection(int id) {
        super(id);
    }

    public ONestedProjection(OrientSql p, int id) {
        super(p, id);
    }

    public Object apply(OExpression expression, Object input, OCommandContext ctx) {
        if (input instanceof OResult) {
            return this.apply(expression, (OResult)input, ctx, this.recursion == null ? 0 : this.recursion.getValue().intValue());
        }
        if (input instanceof OIdentifiable) {
            return this.apply(expression, (OIdentifiable)input, ctx, this.recursion == null ? 0 : this.recursion.getValue().intValue());
        }
        if (input instanceof Map) {
            return this.apply(expression, (Map)input, ctx, this.recursion == null ? 0 : this.recursion.getValue().intValue());
        }
        if (input instanceof Collection) {
            return ((Collection)input).stream().map(x -> this.apply(expression, x, ctx)).collect(Collectors.toList());
        }
        Iterator iter = null;
        if (input instanceof Iterable) {
            iter = ((Iterable)input).iterator();
        }
        if (input instanceof Iterator) {
            iter = (Iterator)input;
        }
        if (iter != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            while (iter.hasNext()) {
                result.add(this.apply(expression, iter.next(), ctx));
            }
            return result;
        }
        return input;
    }

    private Object apply(OExpression expression, OResult elem, OCommandContext ctx, int recursion) {
        OResultInternal result = new OResultInternal();
        if (this.starItem != null || this.includeItems.size() == 0) {
            for (String property : elem.getPropertyNames()) {
                if (this.isExclude(property)) continue;
                result.setProperty(property, this.convert(this.tryExpand(expression, property, elem.getProperty(property), ctx, recursion)));
            }
        }
        if (this.includeItems.size() > 0) {
            for (ONestedProjectionItem item : this.includeItems) {
                String alias = item.alias != null ? item.alias.getStringValue() : item.expression.getDefaultAlias().getStringValue();
                Object value = item.expression.execute(elem, ctx);
                if (item.expansion != null) {
                    value = item.expand(expression, alias, value, ctx, recursion - 1);
                }
                result.setProperty(alias, this.convert(value));
            }
        }
        return result;
    }

    private boolean isExclude(String propertyName) {
        for (ONestedProjectionItem item : this.excludeItems) {
            if (!item.matches(propertyName)) continue;
            return true;
        }
        return false;
    }

    private Object tryExpand(OExpression rootExpr, String propName, Object propValue, OCommandContext ctx, int recursion) {
        if (this.starItem != null && this.starItem.expansion != null) {
            return this.starItem.expand(rootExpr, propName, propValue, ctx, recursion);
        }
        for (ONestedProjectionItem item : this.includeItems) {
            if (!item.matches(propName) || item.expansion == null) continue;
            return item.expand(rootExpr, propName, propValue, ctx, recursion);
        }
        return propValue;
    }

    private Object apply(OExpression expression, OIdentifiable input, OCommandContext ctx, int recursion) {
        OElement elem;
        if (input instanceof OElement) {
            elem = (OElement)input;
        } else {
            Object e = input.getRecord();
            if (e instanceof OElement) {
                elem = (OElement)e;
            } else {
                return input;
            }
        }
        OResultInternal result = new OResultInternal();
        if (this.starItem != null || this.includeItems.size() == 0) {
            for (String property : elem.getPropertyNames()) {
                if (this.isExclude(property)) continue;
                result.setProperty(property, this.convert(this.tryExpand(expression, property, elem.getProperty(property), ctx, recursion)));
            }
        }
        if (this.includeItems.size() > 0) {
            for (ONestedProjectionItem item : this.includeItems) {
                String alias = item.alias != null ? item.alias.getStringValue() : item.expression.getDefaultAlias().getStringValue();
                Object value = item.expression.execute(elem, ctx);
                if (item.expansion != null) {
                    value = item.expand(expression, alias, value, ctx, recursion - 1);
                }
                result.setProperty(alias, this.convert(value));
            }
        }
        return result;
    }

    private Object apply(OExpression expression, Map<String, Object> input, OCommandContext ctx, int recursion) {
        OResultInternal result = new OResultInternal();
        if (this.starItem != null || this.includeItems.size() == 0) {
            for (String property : input.keySet()) {
                if (this.isExclude(property)) continue;
                result.setProperty(property, this.convert(this.tryExpand(expression, property, input.get(property), ctx, recursion)));
            }
        }
        if (this.includeItems.size() > 0) {
            for (ONestedProjectionItem item : this.includeItems) {
                String alias = item.alias != null ? item.alias.getStringValue() : item.expression.getDefaultAlias().getStringValue();
                OResultInternal elem = new OResultInternal();
                input.entrySet().forEach(x -> elem.setProperty((String)x.getKey(), x.getValue()));
                Object value = item.expression.execute(elem, ctx);
                if (item.expansion != null) {
                    value = item.expand(expression, alias, value, ctx, recursion - 1);
                }
                result.setProperty(alias, this.convert(value));
            }
        }
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append(":{");
        boolean first = true;
        if (this.starItem != null) {
            this.starItem.toString(params, builder);
            first = false;
        }
        for (ONestedProjectionItem item : this.includeItems) {
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
        for (ONestedProjectionItem item : this.excludeItems) {
            if (!first) {
                builder.append(", ");
            }
            item.toString(params, builder);
            first = false;
        }
        builder.append("}");
        if (this.recursion != null) {
            builder.append("[");
            this.recursion.toString(params, builder);
            builder.append("]");
        }
    }

    @Override
    public ONestedProjection copy() {
        ONestedProjection result = new ONestedProjection(-1);
        result.includeItems = this.includeItems.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.excludeItems = this.excludeItems.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.starItem = this.starItem == null ? null : this.starItem.copy();
        result.recursion = this.recursion == null ? null : this.recursion.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ONestedProjection that = (ONestedProjection)o;
        if (this.includeItems != null ? !this.includeItems.equals(that.includeItems) : that.includeItems != null) {
            return false;
        }
        if (this.excludeItems != null ? !this.excludeItems.equals(that.excludeItems) : that.excludeItems != null) {
            return false;
        }
        if (this.starItem != null ? !this.starItem.equals(that.starItem) : that.starItem != null) {
            return false;
        }
        return this.recursion != null ? this.recursion.equals(that.recursion) : that.recursion == null;
    }

    public int hashCode() {
        int result = this.includeItems != null ? this.includeItems.hashCode() : 0;
        result = 31 * result + (this.excludeItems != null ? this.excludeItems.hashCode() : 0);
        result = 31 * result + (this.starItem != null ? this.starItem.hashCode() : 0);
        result = 31 * result + (this.recursion != null ? this.recursion.hashCode() : 0);
        return result;
    }

    private Object convert(Object value) {
        if (value instanceof ORidBag) {
            ArrayList result = new ArrayList();
            ((ORidBag)value).forEach(x -> result.add(x));
            return result;
        }
        return value;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.includeItems != null) {
            result.setProperty("includeItems", this.includeItems.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        if (this.excludeItems != null) {
            result.setProperty("excludeItems", this.excludeItems.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        if (this.starItem != null) {
            result.setProperty("starItem", this.starItem.serialize());
        }
        result.setProperty("recursion", this.recursion);
        return result;
    }

    public void deserialize(OResult fromResult) {
        ONestedProjectionItem item;
        List ser;
        if (fromResult.getProperty("includeItems") != null) {
            this.includeItems = new ArrayList<ONestedProjectionItem>();
            ser = (List)fromResult.getProperty("includeItems");
            for (OResult x : ser) {
                item = new ONestedProjectionItem(-1);
                item.deserialize(x);
                this.includeItems.add(item);
            }
        }
        if (fromResult.getProperty("excludeItems") != null) {
            this.excludeItems = new ArrayList<ONestedProjectionItem>();
            ser = (List)fromResult.getProperty("excludeItems");
            for (OResult x : ser) {
                item = new ONestedProjectionItem(-1);
                item.deserialize(x);
                this.excludeItems.add(item);
            }
        }
        if (fromResult.getProperty("starItem") != null) {
            this.starItem = new ONestedProjectionItem(-1);
            this.starItem.deserialize((OResult)fromResult.getProperty("starItem"));
        }
        this.recursion = (OInteger)fromResult.getProperty("recursion");
    }
}

