/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.chm;

import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCacheEntryImpl;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.chm.FrequencySketch;
import com.orientechnologies.orient.core.storage.cache.chm.PageKey;
import com.orientechnologies.orient.core.storage.cache.chm.WTinyLFUPolicy;
import com.orientechnologies.orient.core.storage.cache.chm.readbuffer.BoundedBuffer;
import com.orientechnologies.orient.core.storage.cache.chm.readbuffer.Buffer;
import com.orientechnologies.orient.core.storage.cache.chm.writequeue.MPSCLinkedQueue;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;

public final class AsyncReadCache
implements OReadCache {
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int WRITE_BUFFER_MAX_BATCH = 128 * AsyncReadCache.ceilingPowerOfTwo(NCPU);
    private final ConcurrentHashMap<PageKey, OCacheEntry> data;
    private final Lock evictionLock = new ReentrantLock();
    private final WTinyLFUPolicy policy;
    private final Buffer<OCacheEntry> readBuffer = new BoundedBuffer<OCacheEntry>();
    private final MPSCLinkedQueue<Runnable> writeBuffer = new MPSCLinkedQueue();
    private final AtomicInteger cacheSize = new AtomicInteger();
    private final int maxCacheSize;
    private final boolean trackHitRate;
    private final LongAdder requests = new LongAdder();
    private final LongAdder hits = new LongAdder();
    private final AtomicReference<DrainStatus> drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
    private final int pageSize;
    private final OByteBufferPool bufferPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncReadCache(OByteBufferPool bufferPool, long maxCacheSizeInBytes, int pageSize, boolean trackHitRate) {
        this.evictionLock.lock();
        try {
            this.pageSize = pageSize;
            this.bufferPool = bufferPool;
            this.trackHitRate = trackHitRate;
            this.maxCacheSize = (int)(maxCacheSizeInBytes / (long)pageSize);
            this.data = new ConcurrentHashMap(this.maxCacheSize);
            this.policy = new WTinyLFUPolicy(this.data, new FrequencySketch(), this.cacheSize);
            this.policy.setMaxSize(this.maxCacheSize);
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final long addFile(String fileName, OWriteCache writeCache) throws IOException {
        return writeCache.addFile(fileName);
    }

    @Override
    public final long addFile(String fileName, long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        return writeCache.addFile(fileName, fileId);
    }

    @Override
    public final OCacheEntry loadForWrite(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount, boolean verifyChecksums, OLogSequenceNumber startLSN) {
        OCacheEntry cacheEntry = this.doLoad(fileId, (int)pageIndex, writeCache, verifyChecksums);
        if (cacheEntry != null) {
            cacheEntry.acquireExclusiveLock();
            writeCache.updateDirtyPagesTable(cacheEntry.getCachePointer(), startLSN);
        }
        return cacheEntry;
    }

    @Override
    public final OCacheEntry loadForRead(long fileId, long pageIndex, boolean checkPinnedPages, OWriteCache writeCache, int pageCount, boolean verifyChecksums) {
        return this.doLoad(fileId, (int)pageIndex, writeCache, verifyChecksums);
    }

    /*
     * Unable to fully structure code
     */
    private OCacheEntry doLoad(long extFileId, int pageIndex, OWriteCache writeCache, boolean verifyChecksums) {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), extFileId);
        pageKey = new PageKey(fileId, pageIndex);
        if (this.trackHitRate) {
            this.requests.increment();
        }
        do lbl-1000:
        // 3 sources

        {
            block8: {
                this.checkWriteBuffer();
                cacheEntry = this.data.get(pageKey);
                if (cacheEntry == null) break block8;
                if (!cacheEntry.acquireEntry()) ** GOTO lbl-1000
                this.afterRead(cacheEntry);
                if (this.trackHitRate) {
                    this.hits.increment();
                }
                return cacheEntry;
            }
            read = new boolean[1];
            cacheEntry = this.data.compute(pageKey, (BiFunction<PageKey, OCacheEntry, OCacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$doLoad$200(com.orientechnologies.orient.core.storage.cache.OWriteCache long int boolean boolean[] com.orientechnologies.orient.core.storage.cache.chm.PageKey com.orientechnologies.orient.core.storage.cache.OCacheEntry ), (Lcom/orientechnologies/orient/core/storage/cache/chm/PageKey;Lcom/orientechnologies/orient/core/storage/cache/OCacheEntry;)Lcom/orientechnologies/orient/core/storage/cache/OCacheEntry;)((AsyncReadCache)this, (OWriteCache)writeCache, (long)fileId, (int)pageIndex, (boolean)verifyChecksums, (boolean[])read));
            if (cacheEntry != null) continue;
            return null;
        } while (!cacheEntry.acquireEntry());
        if (read[0]) {
            if (this.trackHitRate) {
                this.hits.increment();
            }
            this.afterRead(cacheEntry);
        } else {
            this.afterAdd(cacheEntry);
            try {
                writeCache.checkCacheOverflow();
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OInterruptedException("Check of write cache overflow was interrupted"), e);
            }
        }
        return cacheEntry;
    }

    private OCacheEntry addNewPagePointerToTheCache(long fileId, int pageIndex) {
        PageKey pageKey = new PageKey(fileId, pageIndex);
        OPointer pointer = this.bufferPool.acquireDirect(true);
        OCachePointer cachePointer = new OCachePointer(pointer, this.bufferPool, fileId, pageIndex);
        cachePointer.incrementReadersReferrer();
        OCacheEntryImpl cacheEntry = new OCacheEntryImpl(fileId, pageIndex, cachePointer);
        cacheEntry.acquireEntry();
        OCacheEntry oldCacheEntry = this.data.putIfAbsent(pageKey, cacheEntry);
        if (oldCacheEntry != null) {
            throw new IllegalStateException("Page  " + fileId + ":" + pageIndex + " was allocated in other thread");
        }
        this.afterAdd(cacheEntry);
        return cacheEntry;
    }

    @Override
    public final void changeMaximumAmountOfMemory(long maxMemory) {
        this.evictionLock.lock();
        try {
            this.policy.setMaxSize((int)(maxMemory / (long)this.pageSize));
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final void releaseFromRead(OCacheEntry cacheEntry, OWriteCache writeCache) {
        cacheEntry.releaseEntry();
    }

    @Override
    public final void releaseFromWrite(OCacheEntry cacheEntry, OWriteCache writeCache) {
        OCachePointer cachePointer = cacheEntry.getCachePointer();
        assert (cachePointer != null);
        PageKey pageKey = new PageKey(cacheEntry.getFileId(), (int)cacheEntry.getPageIndex());
        this.data.compute(pageKey, (page, entry) -> {
            writeCache.store(cacheEntry.getFileId(), cacheEntry.getPageIndex(), cacheEntry.getCachePointer());
            return entry;
        });
        cachePointer.releaseExclusiveLock();
        cacheEntry.releaseEntry();
    }

    @Override
    public final void pinPage(OCacheEntry cacheEntry, OWriteCache writeCache) {
    }

    @Override
    public final OCacheEntry allocateNewPage(long fileId, OWriteCache writeCache, OLogSequenceNumber startLSN) throws IOException {
        int newPageIndex;
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        OCacheEntry cacheEntry = this.addNewPagePointerToTheCache(fileId, newPageIndex = writeCache.allocateNewPage(fileId));
        if (cacheEntry != null) {
            cacheEntry.acquireExclusiveLock();
            writeCache.updateDirtyPagesTable(cacheEntry.getCachePointer(), startLSN);
        }
        return cacheEntry;
    }

    private void afterRead(OCacheEntry entry) {
        boolean bufferOverflow;
        boolean bl = bufferOverflow = this.readBuffer.offer(entry) == 1;
        if (this.drainStatus.get().shouldBeDrained(bufferOverflow)) {
            this.tryToDrainBuffers();
        }
    }

    private void afterAdd(OCacheEntry entry) {
        this.afterWrite(() -> this.policy.onAdd(entry));
    }

    private void afterWrite(Runnable command) {
        this.writeBuffer.offer(command);
        this.drainStatus.lazySet(DrainStatus.REQUIRED);
        if ((double)this.cacheSize.get() > 1.07 * (double)this.maxCacheSize) {
            this.forceDrainBuffers();
        } else {
            this.tryToDrainBuffers();
        }
    }

    private void forceDrainBuffers() {
        this.evictionLock.lock();
        try {
            this.drainStatus.lazySet(DrainStatus.IN_PROGRESS);
            this.emptyBuffers();
        }
        finally {
            try {
                this.drainStatus.compareAndSet(DrainStatus.IN_PROGRESS, DrainStatus.IDLE);
            }
            finally {
                this.evictionLock.unlock();
            }
        }
    }

    private void checkWriteBuffer() {
        if (!this.writeBuffer.isEmpty()) {
            this.drainStatus.lazySet(DrainStatus.REQUIRED);
            this.tryToDrainBuffers();
        }
    }

    private void tryToDrainBuffers() {
        if (this.drainStatus.get() == DrainStatus.IN_PROGRESS) {
            return;
        }
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(DrainStatus.IN_PROGRESS);
                this.drainBuffers();
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.IN_PROGRESS, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    private void drainBuffers() {
        this.drainWriteBuffer();
        this.drainReadBuffers();
    }

    private void emptyBuffers() {
        this.emptyWriteBuffer();
        this.drainReadBuffers();
    }

    private void drainReadBuffers() {
        this.readBuffer.drainTo(this.policy::onAccess);
    }

    private void drainWriteBuffer() {
        Runnable command;
        for (int i = 0; i < WRITE_BUFFER_MAX_BATCH && (command = this.writeBuffer.poll()) != null; ++i) {
            command.run();
        }
    }

    private void emptyWriteBuffer() {
        Runnable command;
        while ((command = this.writeBuffer.poll()) != null) {
            command.run();
        }
    }

    @Override
    public final long getUsedMemory() {
        return (long)this.cacheSize.get() * (long)this.pageSize;
    }

    @Override
    public final void clear() {
        this.evictionLock.lock();
        try {
            this.emptyBuffers();
            for (OCacheEntry entry : this.data.values()) {
                if (entry.freeze()) {
                    this.policy.onRemove(entry);
                    continue;
                }
                throw new OStorageException("Page with index " + entry.getPageIndex() + " for file id " + entry.getFileId() + " is used and cannot be removed");
            }
            this.data.clear();
            this.cacheSize.set(0);
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final void truncateFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        int filledUpTo = (int)writeCache.getFilledUpTo(fileId);
        writeCache.truncateFile(fileId);
        this.clearFile(fileId, filledUpTo, writeCache);
    }

    @Override
    public final void closeFile(long fileId, boolean flush, OWriteCache writeCache) {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        int filledUpTo = (int)writeCache.getFilledUpTo(fileId);
        this.clearFile(fileId, filledUpTo, writeCache);
        writeCache.close(fileId, flush);
    }

    @Override
    public final void deleteFile(long fileId, OWriteCache writeCache) throws IOException {
        fileId = OAbstractWriteCache.checkFileIdCompatibility(writeCache.getId(), fileId);
        int filledUpTo = (int)writeCache.getFilledUpTo(fileId);
        this.clearFile(fileId, filledUpTo, writeCache);
        writeCache.deleteFile(fileId);
    }

    @Override
    public final void deleteStorage(OWriteCache writeCache) throws IOException {
        Collection<Long> files = writeCache.files().values();
        ArrayList<ORawPair<Long, Integer>> filledUpTo = new ArrayList<ORawPair<Long, Integer>>(1024);
        for (long l : files) {
            filledUpTo.add(new ORawPair<Long, Integer>(l, (int)writeCache.getFilledUpTo(l)));
        }
        for (ORawPair oRawPair : filledUpTo) {
            this.clearFile((Long)oRawPair.getFirst(), (Integer)oRawPair.getSecond(), writeCache);
        }
        writeCache.delete();
    }

    @Override
    public final void closeStorage(OWriteCache writeCache) throws IOException {
        Collection<Long> files = writeCache.files().values();
        ArrayList<ORawPair<Long, Integer>> filledUpTo = new ArrayList<ORawPair<Long, Integer>>(1024);
        for (long l : files) {
            filledUpTo.add(new ORawPair<Long, Integer>(l, (int)writeCache.getFilledUpTo(l)));
        }
        for (ORawPair oRawPair : filledUpTo) {
            this.clearFile((Long)oRawPair.getFirst(), (Integer)oRawPair.getSecond(), writeCache);
        }
        writeCache.close();
    }

    @Override
    public final void loadCacheState(OWriteCache writeCache) {
    }

    @Override
    public final void storeCacheState(OWriteCache writeCache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFile(long fileId, int filledUpTo, OWriteCache writeCache) {
        this.evictionLock.lock();
        try {
            this.emptyBuffers();
            for (int pageIndex = 0; pageIndex < filledUpTo; ++pageIndex) {
                PageKey pageKey = new PageKey(fileId, pageIndex);
                OCacheEntry cacheEntry = this.data.remove(pageKey);
                if (cacheEntry == null) continue;
                if (cacheEntry.freeze()) {
                    this.policy.onRemove(cacheEntry);
                    this.cacheSize.decrementAndGet();
                    try {
                        writeCache.checkCacheOverflow();
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw OException.wrapException(new OInterruptedException("Check of write cache overflow was interrupted"), e);
                    }
                }
                throw new OStorageException("Page with index " + cacheEntry.getPageIndex() + " for file id " + cacheEntry.getFileId() + " is used and cannot be removed");
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    void assertSize() {
        this.evictionLock.lock();
        try {
            this.emptyBuffers();
            this.policy.assertSize();
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    void assertConsistency() {
        this.evictionLock.lock();
        try {
            this.emptyBuffers();
            this.policy.assertConsistency();
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    int hitRate() {
        long reqSum = this.requests.sum();
        if (reqSum == 0L) {
            return -1;
        }
        return (int)(this.hits.sum() * 100L / reqSum);
    }

    private static int ceilingPowerOfTwo(int x) {
        return 1 << -Integer.numberOfLeadingZeros(x - 1);
    }

    private /* synthetic */ OCacheEntry lambda$doLoad$200(OWriteCache oWriteCache, long l, int n, boolean bl, boolean[] blArray, PageKey page, OCacheEntry entry) {
        if (entry == null) {
            try {
                OCachePointer[] pointers = oWriteCache.load(l, n, 1, new OModifiableBoolean(), bl);
                if (pointers.length == 0) {
                    return null;
                }
                this.cacheSize.incrementAndGet();
                return new OCacheEntryImpl(page.getFileId(), page.getPageIndex(), pointers[0]);
            }
            catch (IOException e) {
                throw OException.wrapException(new OStorageException("Error during loading of page " + n + " for file " + l), e);
            }
        }
        blArray[0] = true;
        return entry;
    }

    private static enum DrainStatus {
        IDLE{

            @Override
            boolean shouldBeDrained(boolean readBufferOverflow) {
                return readBufferOverflow;
            }
        }
        ,
        IN_PROGRESS{

            @Override
            boolean shouldBeDrained(boolean readBufferOverflow) {
                return false;
            }
        }
        ,
        REQUIRED{

            @Override
            boolean shouldBeDrained(boolean readBufferOverflow) {
                return true;
            }
        };


        abstract boolean shouldBeDrained(boolean var1);
    }
}

