/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.chm;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class LRUList
implements Iterable<OCacheEntry> {
    private int size;
    private OCacheEntry head;
    private OCacheEntry tail;

    void remove(OCacheEntry entry) {
        OCacheEntry next = entry.getNext();
        OCacheEntry prev = entry.getPrev();
        if (next == null && prev == null && entry != this.head) {
            return;
        }
        assert (prev == null || prev.getNext() == entry);
        assert (next == null || next.getPrev() == entry);
        if (next != null) {
            next.setPrev(prev);
        }
        if (prev != null) {
            prev.setNext(next);
        }
        if (this.head == entry) {
            assert (entry.getPrev() == null);
            this.head = next;
        }
        if (this.tail == entry) {
            assert (entry.getNext() == null);
            this.tail = prev;
        }
        entry.setNext(null);
        entry.setPrev(null);
        entry.setContainer(null);
        --this.size;
    }

    boolean contains(OCacheEntry entry) {
        return entry.getContainer() == this;
    }

    void moveToTheTail(OCacheEntry entry) {
        boolean newEntry;
        if (this.tail == entry) {
            assert (entry.getNext() == null);
            return;
        }
        OCacheEntry next = entry.getNext();
        OCacheEntry prev = entry.getPrev();
        boolean bl = newEntry = entry.getContainer() == null;
        assert (entry.getContainer() == null || entry.getContainer() == this);
        assert (prev == null || prev.getNext() == entry);
        assert (next == null || next.getPrev() == entry);
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        if (this.head == entry) {
            assert (entry.getPrev() == null);
            this.head = next;
        }
        entry.setPrev(this.tail);
        entry.setNext(null);
        if (this.tail != null) {
            assert (this.tail.getNext() == null);
            this.tail.setNext(entry);
            this.tail = entry;
        } else {
            this.tail = this.head = entry;
        }
        if (newEntry) {
            entry.setContainer(this);
            ++this.size;
        } else assert (entry.getContainer() == this);
    }

    int size() {
        return this.size;
    }

    OCacheEntry poll() {
        if (this.head == null) {
            return null;
        }
        OCacheEntry entry = this.head;
        OCacheEntry next = this.head.getNext();
        assert (next == null || next.getPrev() == this.head);
        this.head = next;
        if (next != null) {
            next.setPrev(null);
        }
        assert (this.head == null || this.head.getPrev() == null);
        if (this.head == null) {
            this.tail = null;
        }
        entry.setNext(null);
        assert (entry.getPrev() == null);
        --this.size;
        entry.setContainer(null);
        return entry;
    }

    OCacheEntry peek() {
        return this.head;
    }

    @Override
    public Iterator<OCacheEntry> iterator() {
        return new Iterator<OCacheEntry>(){
            private OCacheEntry next;
            {
                this.next = LRUList.this.tail;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public OCacheEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                OCacheEntry result = this.next;
                this.next = this.next.getPrev();
                return result;
            }
        };
    }
}

